/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.composition;

import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.Temporal;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.TimeException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TemporalValue<O extends Serializable>
implements Temporal {
    private static final long serialVersionUID = 1L;
    private Time temporal;
    private O value;

    public TemporalValue(Time t, O o) {
        this.temporal = t;
        this.value = o;
    }

    @Override
    public TemporalValue<O> clone() {
        try {
            TemporalValue clone = (TemporalValue)super.clone();
            clone.temporal = this.temporal.clone();
            try {
                Method m = this.value.getClass().getMethod("clone", null);
                clone.value = (Serializable)m.invoke(this.value, null);
            }
            catch (NoSuchMethodException ex) {
                clone.value = this.value;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "[" + this.temporal.toString() + ", " + this.value.toString() + "]";
    }

    public O getValue() {
        return this.value;
    }

    protected void setValue(O v) {
        this.value = v;
    }

    @Override
    public Time getTime() {
        return this.temporal;
    }

    @Override
    public boolean isActive(Instant t) {
        return this.temporal.isActive(t);
    }

    @Override
    public void kill(Instant t) throws TimeException {
        this.temporal = Time.kill(this.temporal, t);
    }

    @Override
    public void setTime(Time t) {
        this.temporal = t;
    }

    public void delete() {
        this.temporal = null;
        this.value = null;
    }
}

