/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.composition;

import fr.inrae.act.bagap.apiland.core.change.Changeable;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObserver;
import fr.inrae.act.bagap.apiland.core.composition.Attribute;
import fr.inrae.act.bagap.apiland.core.composition.DynamicAttributeType;
import fr.inrae.act.bagap.apiland.core.composition.TemporalValue;
import fr.inrae.act.bagap.apiland.core.dynamic.Dynamic;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.Interval;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.TimeException;
import fr.inrae.act.bagap.apiland.core.time.delay.Delay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DynamicAttribute<O extends Serializable>
extends Attribute<O>
implements Iterable<TemporalValue<O>> {
    private static final long serialVersionUID = 1L;
    private Dynamic<TemporalValue<O>> dynamic = new Dynamic();

    public DynamicAttribute(DynamicAttributeType type) {
        super(type);
    }

    public DynamicAttribute(String name, Class<? extends Time> temporal, Class<O> binding) {
        this(new DynamicAttributeType(name, temporal, binding));
    }

    @Override
    public DynamicAttribute<O> clone() {
        DynamicAttribute clone = (DynamicAttribute)super.clone();
        clone.dynamic = this.dynamic.clone();
        return clone;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        return sb.toString();
    }

    @Override
    public DynamicAttributeType getType() {
        return (DynamicAttributeType)super.getType();
    }

    public Class<? extends Time> getTemporalBinding() {
        return this.getType().getTemporalBinding();
    }

    @Override
    public void addTemporal(TemporalValue<O> t) {
        this.dynamic.addTemporal(t);
    }

    @Override
    public void removeTemporal(TemporalValue<O> t) {
        this.dynamic.removeTemporal(t);
    }

    @Override
    public Time getTime() {
        return this.dynamic.getTime();
    }

    @Override
    public boolean isActive(Instant t) {
        return this.dynamic.isActive(t);
    }

    @Override
    public void kill(Instant t) throws TimeException {
        this.dynamic.kill(t);
    }

    @Override
    public void setTime(Time t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<TemporalValue<O>> iterator() {
        return this.dynamic.iterator();
    }

    @Override
    public void replaceValue(Time t, Serializable o) {
        if (this.getBinding().equals(o.getClass())) {
            this.dynamic.getActive(t.start()).setValue(o);
            this.notifyObservers(t.start(), this, o);
            return;
        }
        throw new IllegalArgumentException("attribute '" + this.getName() + "' expected " + this.getBinding() + " and not " + o.getClass());
    }

    @Override
    public void setValue(TemporalValue<?> tv) {
        if (this.getTemporalBinding().equals(tv.getTime().getClass())) {
            this.dynamic.addTemporal(tv);
            this.notifyObservers(tv.getTime().start(), this, tv.getValue());
            return;
        }
        if (this.getTemporalBinding().equals(Interval.class) && tv.getTime().getClass().equals(Instant.class)) {
            if (this.dynamic.getLast() != null) {
                try {
                    this.dynamic.getLast().kill((Instant)tv.getTime());
                }
                catch (TimeException e) {
                    e.printStackTrace();
                }
            }
            tv.setTime(new Interval((Instant)tv.getTime()));
            this.dynamic.addTemporal(tv);
            this.notifyObservers(tv.getTime().start(), this, tv.getValue());
            return;
        }
        throw new IllegalArgumentException("attribute '" + this.getName() + "' expected " + this.getTemporalBinding() + " and not " + tv.getTime().getClass());
    }

    @Override
    public void setValue(Time t, Serializable o) {
        if (this.getBinding().equals(o.getClass())) {
            if (this.getTemporalBinding().equals(t.getClass())) {
                this.dynamic.addTemporal(new TemporalValue<Serializable>(t, o));
                this.notifyObservers(t.start(), this, o);
                return;
            }
            if (this.getTemporalBinding().equals(Interval.class) && t.getClass().equals(Instant.class)) {
                if (this.dynamic.getLast() != null) {
                    try {
                        this.dynamic.getLast().kill((Instant)t);
                    }
                    catch (TimeException e) {
                        e.printStackTrace();
                    }
                }
                this.dynamic.addTemporal(new TemporalValue<Serializable>(new Interval((Instant)t), o));
                this.notifyObservers(t.start(), this, o);
                return;
            }
            throw new IllegalArgumentException("attribute '" + this.getName() + "' expected " + this.getTemporalBinding() + " and not " + t.getClass());
        }
        throw new IllegalArgumentException("attribute '" + this.getName() + "' expected " + this.getBinding() + " and not " + o.getClass());
    }

    @Override
    public O getValue(Instant t) {
        Iterator<TemporalValue<O>> ite = this.dynamic.iteratorInverse();
        while (ite.hasNext()) {
            TemporalValue<O> tv = ite.next();
            if (!tv.isActive(t)) continue;
            return tv.getValue();
        }
        return null;
    }

    public List<O> values() {
        ArrayList<O> l = new ArrayList<O>();
        for (TemporalValue<O> tv : this) {
            l.add(tv.getValue());
        }
        return l;
    }

    public List<O> values(Interval t) {
        ArrayList<O> l = new ArrayList<O>();
        for (TemporalValue<O> tv : this) {
            if (!tv.getTime().intersects(t)) continue;
            l.add(tv.getValue());
        }
        return l;
    }

    @Override
    public boolean hasValue(Serializable value, Time t) {
        for (TemporalValue<O> tv : this) {
            if (!tv.getTime().intersects(t) || !tv.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Time getTimeForValue(Serializable o) {
        Time t = null;
        for (TemporalValue<O> tv : this) {
            if (!tv.getValue().equals(o)) continue;
            t = Time.add(t, tv.getTime());
        }
        return t;
    }

    public int getCountOfLastValue(Serializable o) {
        int count = 0;
        for (int i = this.dynamic.size() - 1; i >= 0 && this.dynamic.get(i).getValue().equals(o); --i) {
            ++count;
        }
        return count;
    }

    @Override
    public TemporalValue<O> getActive(Instant t) {
        return this.dynamic.getActive(t);
    }

    @Override
    public void addObserver(ChangeableObserver o) {
        this.dynamic.addObserver(o);
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
        this.dynamic.removeObserver(o);
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
        this.dynamic.notifyObservers(t, c, o);
    }

    @Override
    public void display() {
        for (TemporalValue<O> tv : this) {
            System.out.print(tv + " ");
        }
        System.out.println();
    }

    public Dynamic<TemporalValue<O>> getDynamics() {
        return this.dynamic;
    }

    @Override
    public TemporalValue<O> get(int index) {
        return this.dynamic.get(index);
    }

    @Override
    public int size() {
        return this.dynamic.size();
    }

    @Override
    public int getIndex(Instant t) {
        return this.dynamic.getIndex(t);
    }

    @Override
    public TemporalValue<O> getFirst() {
        return this.dynamic.getFirst();
    }

    @Override
    public TemporalValue<O> getLast() {
        return this.dynamic.getLast();
    }

    @Override
    public Instant getLastChange() {
        return this.dynamic.getLastChange();
    }

    @Override
    public void delete() {
        super.delete();
        this.dynamic.delete();
        this.dynamic = null;
    }

    public boolean hasOnlyForValue(Instant start, Instant end, Set<O> value) {
        List<O> values = this.values(new Interval(start, end));
        for (Serializable v : values) {
            if (value.contains(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.dynamic.clear();
    }

    @Override
    public Instant getLastOccurence(Serializable o) {
        Instant t = null;
        for (TemporalValue<O> tv : this) {
            if (!tv.getValue().equals(o)) continue;
            t = tv.getTime().end();
        }
        return t;
    }

    @Override
    public O[] split(Delay d) {
        ArrayList<O> l = new ArrayList<O>();
        Instant end = this.getTime().end();
        if (end.equals(Instant.FUTUR)) {
            end = ((TemporalValue)this.getLast()).getTime().start();
        }
        Instant t = this.getTime().start();
        while (t.isBefore(end) || t.equals(end)) {
            l.add(this.getValue(t));
            t = d.next(t);
        }
        return l.toArray(new Serializable[l.size()]);
    }
}

