/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.composition;

import fr.inrae.act.bagap.apiland.core.change.Changeable;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObserver;
import fr.inrae.act.bagap.apiland.core.composition.Attribute;
import fr.inrae.act.bagap.apiland.core.composition.DiscreteAttributeType;
import fr.inrae.act.bagap.apiland.core.composition.TemporalValue;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.TimeException;
import fr.inrae.act.bagap.apiland.core.time.delay.Delay;
import java.io.Serializable;

public class DiscreteAttribute<O extends Serializable>
extends Attribute<O> {
    private static final long serialVersionUID = 1L;
    private Serializable[] values;

    public DiscreteAttribute(DiscreteAttributeType type) {
        super(type);
        this.values = new Serializable[type.getInternalSize()];
    }

    @Override
    public DiscreteAttributeType getType() {
        return (DiscreteAttributeType)super.getType();
    }

    @Override
    public O getValue(Instant t) {
        return (O)this.values[this.getType().getIndex(t)];
    }

    @Override
    public boolean hasValue(Serializable value, Time t) {
        for (int i = this.getType().getIndex(t.start()); i < this.getType().getIndex(t.end()); ++i) {
            if (!this.values[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive(Instant t) {
        return this.getType().getTime().isActive(t);
    }

    @Override
    public void setValue(Time t, Serializable o) {
        if (t instanceof Instant) {
            this.values[this.getType().getIndex((Instant)((Instant)t))] = o;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void replaceValue(Time t, Serializable o) {
        this.setValue(t, o);
    }

    @Override
    public void delete() {
        super.delete();
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
        this.values = null;
    }

    @Override
    public void addObserver(ChangeableObserver o) {
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
    }

    @Override
    public void setValue(TemporalValue<?> tv) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTemporal(TemporalValue<O> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TemporalValue<O> getActive(Instant t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TemporalValue<O> get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndex(Instant t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TemporalValue<O> getFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TemporalValue<O> getLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(Time t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void kill(Instant t) throws TimeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Instant getLastChange() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void display() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTimeForValue(Serializable o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.values = new Serializable[this.getType().getInternalSize()];
    }

    @Override
    public void removeTemporal(TemporalValue<O> t) {
    }

    @Override
    public Instant getLastOccurence(Serializable o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public O[] split(Delay d) {
        return null;
    }
}

