/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.apiland.core.composition;

import fr.inrae.act.bagap.apiland.core.change.Changeable;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObject;
import fr.inrae.act.bagap.apiland.core.change.ChangeableObserver;
import fr.inrae.act.bagap.apiland.core.composition.Attribute;
import fr.inrae.act.bagap.apiland.core.composition.Composable;
import fr.inrae.act.bagap.apiland.core.time.Instant;
import fr.inrae.act.bagap.apiland.core.time.Time;
import fr.inrae.act.bagap.apiland.core.time.TimeException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Composition
implements Composable,
Iterable<Attribute<?>> {
    private static final long serialVersionUID = 1L;
    private Map<String, Attribute<?>> attributes = new HashMap();
    private ChangeableObject changeable = new ChangeableObject();

    public Composition clone() {
        try {
            Composition clone = (Composition)super.clone();
            clone.changeable = new ChangeableObject();
            if (this.attributes != null) {
                clone.attributes = new HashMap();
                for (Map.Entry<String, Attribute<?>> s : this.attributes.entrySet()) {
                    clone.attributes.put(s.getKey(), (Attribute<?>)s.getValue().clone());
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public Composition getComposition() {
        return this;
    }

    @Override
    public void setComposition(Composition composition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Attribute<?>> iterator() {
        return this.attributes.values().iterator();
    }

    public void addAttribute(Attribute<?> d) {
        this.attributes.put(d.getName(), d);
        d.addObserver(this);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Time getAttributeTime(String name) {
        return this.getAttribute(name).getTime();
    }

    public Object getValue(String s, Instant t) {
        return this.attributes.get(s).getValue(t);
    }

    @Override
    public void kill(Instant t) throws TimeException {
        for (Attribute<?> da : this) {
            da.kill(t);
        }
    }

    public void display() {
        for (Attribute<?> a : this) {
            a.display();
        }
    }

    @Override
    public void update(Instant t, Changeable c, Object o) {
        this.notifyObservers(t, this, o);
    }

    @Override
    public void addObserver(ChangeableObserver o) {
        this.changeable.addObserver(o);
        for (Attribute<?> a : this) {
            a.addObserver(o);
        }
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
        this.changeable.removeObserver(o);
        for (Attribute<?> a : this) {
            a.removeObserver(o);
        }
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
        this.changeable.notifyObservers(t, c, o);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public int size() {
        return this.attributes.size();
    }

    @Override
    public Instant getLastChange() {
        Instant t = null;
        for (Attribute<?> a : this) {
            Instant n = a.getLastChange();
            if (t != null && (n == null || !n.isAfter(t))) continue;
            t = n;
        }
        return t;
    }

    public void delete() {
        for (Attribute<?> a : this.attributes.values()) {
            a.delete();
        }
        this.attributes.clear();
        this.attributes = null;
        this.changeable.delete();
        this.changeable = null;
    }
}

