/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.geotools.geopkg.Tile;

public class TileReader
implements Iterator<Tile>,
Closeable {
    ResultSet rs;
    Connection cx;
    Boolean next;

    public TileReader(ResultSet rs, Connection cx) {
        this.rs = rs;
        this.cx = cx;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            try {
                this.next = this.rs.next();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.next;
    }

    @Override
    public Tile next() {
        Tile t = new Tile();
        try {
            t.setZoom(this.rs.getInt("zoom_level"));
            t.setColumn(this.rs.getInt("tile_column"));
            t.setRow(this.rs.getInt("tile_row"));
            t.setData(this.rs.getBytes("tile_data"));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.next = null;
        return t;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        try {
            Statement st = this.rs.getStatement();
            this.rs.close();
            if (st != null && !st.isClosed()) {
                st.close();
            }
            this.cx.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

