/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geopkg.Entry;
import org.geotools.geopkg.FeatureEntry;
import org.geotools.geopkg.GeoPackage;
import org.geotools.geopkg.GeoPkgFilterToSQL;
import org.geotools.geopkg.geom.GeoPkgGeomReader;
import org.geotools.geopkg.geom.GeoPkgGeomWriter;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoPkgDialect
extends PreparedStatementSQLDialect {
    static final String HAS_SPATIAL_INDEX = "hasGeopkgSpatialIndex";
    protected GeoPkgGeomWriter.Configuration geomWriterConfig;

    public GeoPkgDialect(JDBCDataStore dataStore, GeoPkgGeomWriter.Configuration writerConfig) {
        super(dataStore);
        this.geomWriterConfig = writerConfig;
    }

    public GeoPkgDialect(JDBCDataStore dataStore) {
        super(dataStore);
        this.geomWriterConfig = new GeoPkgGeomWriter.Configuration();
    }

    public void initializeConnection(Connection cx) throws SQLException {
        GeoPackage.init(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            boolean bl;
            ResultSet rs = st.executeQuery(String.format("SELECT * FROM gpkg_contents WHERE table_name = '%s' AND data_type = '%s'", tableName, Entry.DataType.Feature.value()));
            try {
                bl = rs.next();
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return bl;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        super.encodePrimaryKey(column, sql);
        sql.append(" AUTOINCREMENT");
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.encodeColumnName(null, geometryColumn, sql);
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        Geometry g = this.geometry(rs.getBytes(column));
        return g != null ? g.getEnvelopeInternal() : null;
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        return this.geometry(descriptor.getType().getBinding(), rs.getBytes(column), factory, hints);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        return this.geometry(descriptor.getType().getBinding(), rs.getBytes(column), factory, hints);
    }

    public void setGeometryValue(Geometry g, int dimension, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
        if (g == null || g.isEmpty()) {
            ps.setNull(column, 2004);
        } else {
            g.setSRID(srid);
            try {
                ps.setBytes(column, new GeoPkgGeomWriter(dimension, this.geomWriterConfig).write(g));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Geometry geometry(Class geometryType, byte[] bytes, GeometryFactory factory, Hints hints) throws IOException {
        GeoPkgGeomReader geoPkgGeomReader = new GeoPkgGeomReader(bytes);
        geoPkgGeomReader.setFactory(factory);
        geoPkgGeomReader.setHints(hints);
        geoPkgGeomReader.setGeometryType(geometryType);
        return bytes != null ? geoPkgGeomReader.get() : null;
    }

    Geometry geometry(byte[] b) throws IOException {
        return this.geometry(null, b, null, null);
    }

    public String getGeometryTypeName(Integer type) {
        return Geometries.getForSQLType((int)type).getName();
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("DOUBLE", Double.class);
        mappings.put("BOOLEAN", Boolean.class);
        mappings.put("DATE", Date.class);
        mappings.put("TIMESTAMP", Timestamp.class);
        mappings.put("TIME", Time.class);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        for (Geometries g : Geometries.values()) {
            mappings.put(g.getBinding(), g.getSQLType());
        }
        mappings.put(Long.class, 4);
        mappings.put(Double.class, 7);
        mappings.put(Boolean.class, 4);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        super.registerSqlTypeToSqlTypeNameOverrides(overrides);
        overrides.put(16, "BOOLEAN");
        overrides.put(5, "SMALLINT");
        overrides.put(-5, "BIGINT");
        overrides.put(8, "DOUBLE");
        overrides.put(2, "NUMERIC");
        overrides.put(91, "DATE");
        overrides.put(92, "TIME");
        overrides.put(93, "TIMESTAMP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getMapping(ResultSet columns, Connection cx) throws SQLException {
        String tbl = columns.getString("TABLE_NAME");
        String col = columns.getString("COLUMN_NAME");
        String sql = String.format("SELECT b.geometry_type_name FROM %s a, %s b WHERE a.table_name = b.table_name AND b.table_name = ? AND b.column_name = ?", "gpkg_contents", "gpkg_geometry_columns");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("%s; 1=%s, 2=%s", sql, tbl, col));
        }
        PreparedStatement ps = cx.prepareStatement(sql);
        try {
            String t;
            Geometries g;
            ps.setString(1, tbl);
            ps.setString(2, col);
            ResultSet rs = ps.executeQuery();
            if (rs.next() && (g = Geometries.getForName((String)(t = rs.getString(1)))) != null) {
                Class clazz = g.getBinding();
                return clazz;
            }
            rs.close();
        }
        finally {
            this.dataStore.closeSafe((Statement)ps);
        }
        return null;
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        CoordinateReferenceSystem crs;
        GeometryDescriptor gd;
        FeatureEntry fe = (FeatureEntry)featureType.getUserData().get(FeatureEntry.class);
        if (fe == null) {
            fe = new FeatureEntry();
            fe.setIdentifier(featureType.getTypeName());
            fe.setDescription(featureType.getTypeName());
            fe.setTableName(featureType.getTypeName());
            fe.setLastChange(new java.util.Date());
        }
        if ((gd = featureType.getGeometryDescriptor()) != null) {
            fe.setGeometryColumn(gd.getLocalName());
            fe.setGeometryType(Geometries.getForBinding((Class)gd.getType().getBinding()));
        }
        if ((crs = featureType.getCoordinateReferenceSystem()) != null) {
            Integer epsgCode = null;
            try {
                epsgCode = CRS.lookupEpsgCode(crs, true);
            }
            catch (FactoryException e) {
                LOGGER.log(Level.WARNING, "Error looking up epsg code for " + crs, e);
            }
            if (epsgCode != null) {
                fe.setSrid(epsgCode);
            }
        }
        GeoPackage geopkg = this.geopkg();
        try {
            geopkg.addGeoPackageContentsEntry(fe);
            geopkg.addGeometryColumnsEntry(fe);
            for (PropertyDescriptor descr : featureType.getDescriptors()) {
                GeometryDescriptor gd1;
                if (!(descr instanceof GeometryDescriptor) || (gd1 = (GeometryDescriptor)descr).getLocalName().equals(fe.getGeometryColumn())) continue;
                FeatureEntry fe1 = new FeatureEntry();
                fe1.init(fe);
                fe1.setGeometryColumn(gd1.getLocalName());
                fe1.setGeometryType(Geometries.getForBinding((Class)gd1.getType().getBinding()));
                geopkg.addGeometryColumnsEntry(fe1);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public void postDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        super.postDropTable(schemaName, featureType, cx);
        FeatureEntry fe = (FeatureEntry)featureType.getUserData().get(FeatureEntry.class);
        if (fe == null) {
            fe = new FeatureEntry();
            fe.setIdentifier(featureType.getTypeName());
            fe.setDescription(featureType.getTypeName());
            fe.setTableName(featureType.getTypeName());
        }
        GeoPackage geopkg = this.geopkg();
        try {
            geopkg.deleteGeoPackageContentsEntry(fe);
            geopkg.deleteGeometryColumnsEntry(fe);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        try {
            FeatureEntry fe = this.geopkg().feature(tableName);
            return fe != null ? fe.getSrid() : null;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public int getGeometryDimension(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        try {
            FeatureEntry fe = this.geopkg().feature(tableName);
            if (fe != null) {
                return 2 + (fe.isZ() ? 1 : 0) + (fe.isM() ? 1 : 0);
            }
            return super.getGeometryDimension(schemaName, tableName, columnName, cx);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        try {
            return CRS.decode("EPSG:" + srid, true);
        }
        catch (Exception e) {
            block8: {
                LOGGER.log(Level.FINE, "Unable to create CRS from epsg code " + srid, e);
                String sql = String.format("SELECT definition FROM %s WHERE auth_srid = %d", "gpkg_spatial_ref_sys", srid);
                LOGGER.fine(sql);
                Statement st = cx.createStatement();
                ResultSet rs = st.executeQuery(sql);
                try {
                    if (!rs.next()) break block8;
                    String wkt = rs.getString(1);
                    try {
                        CoordinateReferenceSystem coordinateReferenceSystem = CRS.parseWKT(wkt);
                        return coordinateReferenceSystem;
                    }
                    catch (Exception e2) {
                        LOGGER.log(Level.FINE, "Unable to create CRS from wkt: " + wkt, e2);
                    }
                }
                finally {
                    this.dataStore.closeSafe(rs);
                    this.dataStore.closeSafe(st);
                }
            }
            return super.createCRS(srid, cx);
        }
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            ResultSet rs = st.executeQuery("SELECT last_insert_rowid()");
            try {
                if (rs.next()) {
                    Integer n = rs.getInt(1);
                    return n;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    GeoPackage geopkg() {
        return new GeoPackage(this.dataStore);
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit > 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT " + limit);
            if (offset > 0) {
                sql.append(" OFFSET " + offset);
            }
        } else if (offset > 0) {
            sql.append(" LIMIT -1");
            sql.append(" OFFSET " + offset);
        }
    }

    public PreparedFilterToSQL createPreparedFilterToSQL() {
        GeoPkgFilterToSQL fts = new GeoPkgFilterToSQL(this);
        return fts;
    }

    public void setValue(Object value, Class binding, PreparedStatement ps, int column, Connection cx) throws SQLException {
        Integer sqlType = this.dataStore.getMapping(binding);
        if (value == null) {
            ps.setNull(column, sqlType);
            return;
        }
        switch (sqlType) {
            case 91: {
                ps.setString(column, ((Date)value).toString());
                break;
            }
            case 92: {
                ps.setString(column, ((Time)value).toString());
                break;
            }
            case 93: {
                ps.setString(column, ((Timestamp)value).toString());
                break;
            }
            default: {
                super.setValue(value, binding, ps, column, cx);
            }
        }
    }

    public void encodeColumnType(String sqlTypeName, StringBuffer sql) {
        sql.append(sqlTypeName.toUpperCase());
    }

    public void postCreateAttribute(AttributeDescriptor att, String tableName, String schemaName, Connection cx) throws SQLException {
        super.postCreateAttribute(att, tableName, schemaName, cx);
        if (att instanceof GeometryDescriptor) {
            String sql = "SELECT * FROM gpkg_extensions WHERE (lower(table_name)=lower('" + tableName + "') AND lower(column_name)=lower('" + att.getLocalName() + "') AND extension_name='gpkg_rtree_index')";
            try (Statement st = cx.createStatement();
                 ResultSet rs = st.executeQuery(sql);){
                boolean hasSpatialIndex = rs.next();
                att.getUserData().put(HAS_SPATIAL_INDEX, hasSpatialIndex);
            }
        }
    }

    public Filter[] splitFilter(Filter filter, SimpleFeatureType schema) {
        Envelope envelope;
        GeometryDescriptor searchAttribute = this.simpleSpatialSearch(filter, schema);
        if (!(searchAttribute == null || (envelope = (Envelope)filter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, null)) == null || envelope.isNull() || Double.isInfinite(envelope.getWidth()) || Double.isInfinite(envelope.getHeight()))) {
            Filter[] split = super.splitFilter(filter, schema);
            FilterFactory ff = this.dataStore.getFilterFactory();
            BBOX bbox = ff.bbox(searchAttribute.getLocalName(), envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), null);
            split[0] = ff.and(split[0], (Filter)bbox);
            return split;
        }
        return super.splitFilter(filter, schema);
    }

    private GeometryDescriptor simpleSpatialSearch(Filter filter, SimpleFeatureType schema) {
        FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
        filter.accept((FilterVisitor)attributeExtractor, null);
        Set attributes = attributeExtractor.getAttributeNameSet();
        GeometryDescriptor geometryAttribute = null;
        for (String name : attributes) {
            Object ad = "".equals(name) ? schema.getGeometryDescriptor() : schema.getDescriptor(name);
            if (!(ad instanceof GeometryDescriptor)) continue;
            if (geometryAttribute != null) {
                return null;
            }
            geometryAttribute = ad;
        }
        return geometryAttribute;
    }

    protected PrimaryKey getPrimaryKey(String typeName) throws IOException {
        return super.getPrimaryKey(typeName);
    }

    protected <T> T convert(Object value, Class<T> binding) {
        if (Integer.class.equals(binding) && value instanceof Boolean) {
            return (T)Integer.valueOf(Boolean.TRUE.equals(value) ? 1 : 0);
        }
        return (T)super.convert(value, binding);
    }

    public String getPkColumnValue(ResultSet rs, PrimaryKeyColumn pkey, int columnIdx) throws SQLException {
        if (Integer.class.equals((Object)pkey.getType())) {
            return String.valueOf(rs.getInt(columnIdx));
        }
        return rs.getString(columnIdx);
    }

    protected void addSupportedHints(Set<Hints.Key> hints) {
        hints.add(Hints.GEOMETRY_DISTANCE);
        hints.add(Hints.SCREENMAP);
    }
}

