/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.raster.Tile;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class TileRasterOutput
implements CountingObserver {
    private String folder;
    private Metric metric;
    private Tile tile;
    private int tileSize;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double cellSize;
    private int noDataValue;
    private float[][] tabs;
    private boolean[] actives;
    private int width;
    private int height;
    private int initMinX;
    private int initMinY;
    private int theX;
    private int theY;
    private int tY;
    private final CoordinateReferenceSystem crs;

    public TileRasterOutput(String folder, Metric metric, Tile tile, int width, int height, double minX, double maxX, double minY, double maxY, double cellSize, int noDataValue, CoordinateReferenceSystem crs) {
        this.folder = folder;
        this.metric = metric;
        this.tile = new Tile(new Envelope(minX, maxX, minY, maxY), tile.getNcols(), tile.getNrows(), tile.getTileLength(), tile.grid());
        this.width = width;
        this.height = height;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.crs = crs;
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        this.tileSize = new Double(this.tile.getTileLength() / this.cellSize).intValue();
        this.actives = new boolean[this.tile.getNcols()];
        this.tabs = new float[this.tile.getNcols()][new Double(Math.pow(this.tileSize, 2.0)).intValue()];
        this.initMinX = new Double((this.minX - this.tile.getMinX()) / this.cellSize).intValue();
        this.initMinY = new Double((this.tile.getMaxY() - this.maxY) / this.cellSize).intValue();
        this.tY = 0;
        this.theX = this.initMinX;
        this.theY = this.initMinY;
        this.resetTabs();
        for (int y = 0; y < this.initMinY; ++y) {
            for (int t = 0; t < this.tile.getNcols(); ++t) {
                for (int x = 0; x < this.tileSize; ++x) {
                    this.tabs[t][y * this.tileSize + x] = this.noDataValue;
                }
            }
        }
    }

    @Override
    public void postrun(Counting c, int i, int j, Set<Metric> metrics) {
        if (this.theX == this.initMinX) {
            for (int x = 0; x < this.theX; ++x) {
                this.tabs[0][this.theY * this.tileSize + x] = this.noDataValue;
            }
        }
        double v = this.metric.value();
        int t = this.theX / this.tileSize;
        int x = this.theX % this.tileSize;
        if (!this.actives[t] && v != (double)this.noDataValue) {
            this.actives[t] = true;
        }
        this.tabs[t][this.theY * this.tileSize + x] = Float.parseFloat(Util.format(v));
        ++this.theX;
        if (this.theX - this.initMinX >= this.width) {
            ++x;
            while (x < this.tileSize) {
                this.tabs[t][this.theY * this.tileSize + x] = this.noDataValue;
                ++x;
            }
            ++this.theY;
            this.theX = this.initMinX;
            boolean export = false;
            if (this.tY + 1 == this.tile.getNrows() && this.tY * this.tileSize + this.theY == this.initMinY + this.height) {
                for (int y = this.theY; y < this.tileSize; ++y) {
                    for (t = 0; t < this.tile.getNcols(); ++t) {
                        for (x = 0; x < this.tileSize; ++x) {
                            this.tabs[t][y * this.tileSize + x] = this.noDataValue;
                        }
                    }
                }
                export = true;
            }
            if (export || this.theY == this.tileSize) {
                this.exportTabs();
                this.resetTabs();
                this.theY = 0;
                ++this.tY;
            }
        }
    }

    private void resetTabs() {
        for (int t = 0; t < this.tile.getNcols(); ++t) {
            this.actives[t] = false;
        }
    }

    private void exportTabs() {
        for (int t = 0; t < this.tile.getNcols(); ++t) {
            if (!this.actives[t]) continue;
            this.exportTab(t);
        }
    }

    private void exportTab(int tX) {
        if (this.tile.hasTile(tX, this.tY)) {
            Envelope e = this.tile.getEnvelope(tX, this.tY);
            EnteteRaster entete = new EnteteRaster(this.tileSize, this.tileSize, e.getMinX(), e.getMaxX(), e.getMinY(), e.getMaxY(), (float)this.cellSize, this.noDataValue, this.crs);
            this.writeRaster(this.folder + this.metric.getName() + "_" + (int)e.getMinX() / 1000 + "_" + (int)e.getMaxY() / 1000, this.tabs[tX], entete);
        }
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
        this.tabs = null;
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }

    protected abstract void writeRaster(String var1, float[] var2, EnteteRaster var3);
}

