/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.raster.PixelWithID;
import fr.inrae.act.bagap.apiland.util.CoordinateManager;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;

public class SelectedCsvOutput
implements CountingObserver {
    private final StringBuffer sb;
    private BufferedWriter bw;
    private String csv;
    private Set<Pixel> pixels;
    private EnteteRaster entete;

    public SelectedCsvOutput(String csv, Set<Pixel> pixels, EnteteRaster entete) {
        this.csv = csv;
        this.pixels = pixels;
        this.entete = entete;
        this.sb = new StringBuffer();
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        try {
            this.bw = new BufferedWriter(new FileWriter(this.csv));
            if (this.pixels.iterator().next() instanceof PixelWithID) {
                this.bw.write("id;");
            }
            this.bw.write("X;");
            this.bw.write("Y");
            for (Metric m : metrics) {
                this.bw.write(";" + m.getName());
            }
            this.bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, Pixel pix, Set<Metric> metrics) {
        Pixel pixel = null;
        for (Pixel p : this.pixels) {
            if (p != pix) continue;
            pixel = p;
            break;
        }
        if (pixel != null) {
            try {
                boolean export = true;
                this.sb.setLength(0);
                if (pixel instanceof PixelWithID) {
                    this.sb.append(((PixelWithID)pixel).getId() + ";" + ((PixelWithID)pixel).getX() + ";" + ((PixelWithID)pixel).getY());
                } else {
                    this.sb.append(CoordinateManager.getProjectedX(this.entete, pixel.x()) + ";" + CoordinateManager.getProjectedY(this.entete, pixel.y()));
                }
                for (Metric m : metrics) {
                    double v = m.value();
                    if (v == (double)this.entete.noDataValue()) {
                        export = false;
                        break;
                    }
                    this.sb.append(';');
                    this.sb.append(Util.format(v));
                }
                if (export) {
                    this.bw.write(this.sb.toString());
                    this.bw.newLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
        try {
            this.bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, int i, int j, Set<Metric> metrics) {
    }
}

