/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;

public class MapCsvOutput
implements CountingObserver {
    private BufferedWriter bw;
    private String csv;
    private String name;

    public MapCsvOutput(String csv, String name) {
        this.csv = csv;
        this.name = name;
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        try {
            this.bw = new BufferedWriter(new FileWriter(this.csv));
            this.bw.write("raster");
            for (Metric m : metrics) {
                this.bw.write(";" + m.getName());
            }
            this.bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int i, int j, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
        try {
            this.bw.write(this.name);
            for (Metric m : metrics) {
                double v = m.value();
                this.bw.write(";" + Util.format(v));
            }
            this.bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
        try {
            this.bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

