/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.util.Arrays;
import java.util.Set;

public class InterpolateSplineLinearTabOutput
implements CountingObserver {
    private final float[] datas;
    private final Metric metric;
    private final int width;
    private final int delta;
    private int maxI;
    private float[] line;
    private float[] oldLine;
    private int noDataValue;

    public InterpolateSplineLinearTabOutput(float[] datas, Metric metric, int width, int displacement, int noDataValue) {
        this.datas = datas;
        this.metric = metric;
        this.width = width;
        this.delta = displacement;
        this.noDataValue = noDataValue;
    }

    public Metric getMetric() {
        return this.metric;
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        Arrays.fill(this.datas, (float)this.noDataValue);
        this.line = new float[this.width];
        Arrays.fill(this.line, (float)this.noDataValue);
        this.maxI = this.getMaxI(this.width, this.delta);
    }

    private int getMaxI(int w, int d) {
        return d * ((w - 1) / d);
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int i, int j, Set<Metric> metrics) {
        this.line[i] = (float)this.metric.value();
        if (i > 0) {
            int x;
            for (x = 1; x < this.delta; ++x) {
                this.line[i - this.delta + x] = Float.parseFloat(Util.format(this.droite(this.line[i - this.delta], this.line[i], x)));
            }
            if (i == this.maxI) {
                if (j != 0) {
                    for (int y = 1; y < this.delta; ++y) {
                        for (int x2 = 0; x2 < this.width; ++x2) {
                            this.datas[(j - this.delta + y) * this.width + x2] = Float.parseFloat(Util.format(this.droite(this.oldLine[x2], this.line[x2], y)));
                        }
                    }
                }
                for (x = 0; x < this.width; ++x) {
                    this.datas[j * this.width + x] = this.line[x];
                }
                this.oldLine = (float[])this.line.clone();
                Arrays.fill(this.line, (float)this.noDataValue);
            }
        }
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
    }

    private double droite(double v, double v_delta, double x) {
        if (v == (double)this.noDataValue || v_delta == (double)this.noDataValue) {
            return this.noDataValue;
        }
        return x * (v_delta - v) / (double)this.delta + v;
    }
}

