/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.util.CoordinateManager;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class InterpolateSplineLinearCsvOutput
implements CountingObserver {
    private BufferedWriter bw;
    private final String csv;
    private double x;
    private double y;
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    private final double cellSize;
    private final int width;
    private final int height;
    private final int noDataValue;
    private final int delta;
    private final int maxWidth;
    private final int maxHeight;
    private final CoordinateReferenceSystem crs;
    private Map<String, double[]> values_d;
    private Map<String, Map<Integer, double[]>> values;

    public InterpolateSplineLinearCsvOutput(String csv, double minX, double maxX, double minY, double maxY, int width, int height, double cellSize, int noDataValue, CoordinateReferenceSystem crs, int displacement) {
        this.csv = csv;
        this.x = minX;
        this.y = maxY;
        this.cellSize = cellSize;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.width = width;
        this.height = height;
        this.delta = displacement;
        this.noDataValue = noDataValue;
        this.crs = crs;
        this.maxWidth = width - (width - 1) % this.delta - 1;
        this.maxHeight = height - (height - 1) % this.delta - 1;
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        try {
            this.bw = new BufferedWriter(new FileWriter(this.csv));
            this.bw.write("X;Y");
            for (Metric m : metrics) {
                this.bw.write(";" + m.getName());
            }
            this.bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.values = new TreeMap<String, Map<Integer, double[]>>();
        this.values_d = new TreeMap<String, double[]>();
        for (Metric wm : metrics) {
            this.values.put(wm.getName(), new TreeMap());
            this.values.get(wm.getName()).put(0, new double[this.width]);
            for (int i = 0; i < this.width; ++i) {
                this.values.get((Object)wm.getName()).get((Object)Integer.valueOf((int)0))[i] = this.noDataValue;
            }
            this.values_d.put(wm.getName(), new double[this.width]);
        }
        this.writeHeader();
    }

    private void writeHeader() {
        EnteteRaster entete = new EnteteRaster(this.width, this.height, this.minX, this.maxX, this.minY, this.maxY, (float)this.cellSize, this.noDataValue, this.crs);
        EnteteRaster.export(entete, this.csv.replace(".csv", "_header.txt"));
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int i, int j, Set<Metric> metrics) {
        int ii;
        double v;
        for (Metric m : metrics) {
            v = m.value();
            String metric = m.getName();
            if (!this.values.get(metric).containsKey(j)) {
                for (int ii2 = 0; ii2 < this.width; ++ii2) {
                    this.values_d.get((Object)metric)[ii2] = this.values.get(metric).get(j - this.delta)[ii2];
                }
                for (int yv = 1; yv <= this.delta; ++yv) {
                    this.values.get(metric).put(j - this.delta + yv, new double[this.width]);
                    for (ii = 0; ii < this.width; ++ii) {
                        this.values.get((Object)metric).get((Object)Integer.valueOf((int)(j - this.delta + yv)))[ii] = this.noDataValue;
                    }
                }
            }
            this.values.get((Object)metric).get((Object)Integer.valueOf((int)j))[i] = v;
        }
        if (j != 0 && i == 0) {
            double[] vv = new double[this.values.keySet().size()];
            if (j > this.delta) {
                for (int yv = 1; yv <= this.delta; ++yv) {
                    int yy = j - 2 * this.delta + yv;
                    for (int ii3 = 0; ii3 < this.width; ++ii3) {
                        int im = 0;
                        for (String m : this.values.keySet()) {
                            vv[im++] = this.values.get(m).get(yy)[ii3];
                        }
                        this.write(vv, ii3, yy);
                    }
                    for (String m : this.values.keySet()) {
                        this.values.get(m).remove(yy);
                    }
                }
            } else {
                for (ii = 0; ii < this.width; ++ii) {
                    int im = 0;
                    for (String m : this.values.keySet()) {
                        vv[im++] = this.values.get(m).get(0)[ii];
                    }
                    this.write(vv, ii, 0);
                }
            }
        }
        for (String m : this.values.keySet()) {
            int xv;
            if (j == 0) {
                if (i == 0) {
                    for (int ii4 = 1; ii4 < this.width; ++ii4) {
                        this.values.get((Object)m).get((Object)Integer.valueOf((int)0))[ii4] = this.noDataValue;
                    }
                    continue;
                }
                v = this.values.get(m).get(0)[i];
                for (xv = 1; xv < this.delta; ++xv) {
                    this.values.get((Object)m).get((Object)Integer.valueOf((int)0))[i - this.delta + xv] = this.droite(this.values.get(m).get(0)[i - this.delta], v, xv);
                }
                continue;
            }
            if (i == 0) {
                v = this.values.get(m).get(j)[0];
                for (int yv = 1; yv < this.delta; ++yv) {
                    this.values.get((Object)m).get((Object)Integer.valueOf((int)(j - this.delta + yv)))[0] = this.droite(this.values_d.get(m)[0], v, yv);
                }
                continue;
            }
            v = this.values.get(m).get(j)[i];
            for (xv = 1; xv < this.delta; ++xv) {
                this.values.get((Object)m).get((Object)Integer.valueOf((int)j))[i - this.delta + xv] = this.droite(this.values.get(m).get(j)[i - this.delta], v, xv);
            }
            for (int yv = 1; yv < this.delta; ++yv) {
                double vh;
                this.values.get((Object)m).get((Object)Integer.valueOf((int)(j - this.delta + yv)))[i] = vh = this.droite(this.values_d.get(m)[i], v, yv);
                for (int xv2 = 1; xv2 < this.delta; ++xv2) {
                    this.values.get((Object)m).get((Object)Integer.valueOf((int)(j - this.delta + yv)))[i - this.delta + xv2] = this.droite(this.values.get(m).get(j - this.delta + yv)[i - this.delta], vh, xv2);
                }
            }
        }
        if (j == this.maxHeight && i == this.maxWidth) {
            Object vv = new double[this.values.keySet().size()];
            for (int yv = 1; yv <= this.delta; ++yv) {
                int yy = j - this.delta + yv;
                for (int ii5 = 0; ii5 < this.width; ++ii5) {
                    int im = 0;
                    for (String m : this.values.keySet()) {
                        vv[im++] = this.values.get(m).get(yy)[ii5];
                    }
                    this.write((double[])vv, ii5, yy);
                }
            }
            for (int jj = this.maxHeight + 1; jj < this.height; ++jj) {
                for (int ii6 = 0; ii6 < this.width; ++ii6) {
                    int im = 0;
                    for (String m : this.values.keySet()) {
                        vv[im++] = (double)this.noDataValue;
                    }
                    this.write((double[])vv, ii6, jj);
                }
            }
        }
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
        try {
            this.bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private double droite(double v_delta, double v, double yv) {
        if (v == (double)this.noDataValue || v_delta == (double)this.noDataValue) {
            return this.noDataValue;
        }
        return yv * (v - v_delta) / (double)this.delta + v_delta;
    }

    private void write(double[] vv, int i, int j) {
        boolean export = false;
        for (double v : vv) {
            if (v == (double)this.noDataValue) continue;
            export = true;
            break;
        }
        if (export) {
            try {
                this.bw.write(CoordinateManager.getProjectedX(this.minX, this.cellSize, i) + ";");
                this.bw.write(CoordinateManager.getProjectedY(this.minY, this.cellSize, this.height, j) + "");
                for (double v : vv) {
                    this.bw.write(";" + Util.format(v));
                }
                this.bw.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }
}

