/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class InterpolateSplineLinearAsciiGridOutput
implements CountingObserver {
    private String file;
    private Metric metric;
    private final int width;
    private final int height;
    private final int noDataValue;
    private final int delta;
    private final int maxWidth;
    private final int maxHeight;
    private final double xllCorner;
    private final double yllCorner;
    private final double cellSize;
    private BufferedWriter writer;
    private int yGlobal;
    private double[] values_d;
    private Map<Integer, double[]> values;

    public InterpolateSplineLinearAsciiGridOutput(String file, Metric metric, int width, int height, double xllCorner, double yllCorner, double cellSize, int noDataValue, int displacement) {
        this.file = file;
        this.metric = metric;
        this.width = width;
        this.height = height;
        this.xllCorner = xllCorner;
        this.yllCorner = yllCorner;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.delta = displacement;
        this.maxWidth = width - (width - 1) % this.delta - 1;
        this.maxHeight = height - (height - 1) % this.delta - 1;
        this.yGlobal = -1;
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.file));
            this.writer.write("ncols " + this.width);
            this.writer.newLine();
            this.writer.write("nrows " + this.height);
            this.writer.newLine();
            this.writer.write("xllcorner " + this.xllCorner);
            this.writer.newLine();
            this.writer.write("yllcorner " + this.yllCorner);
            this.writer.newLine();
            this.writer.write("cellsize " + this.cellSize);
            this.writer.newLine();
            this.writer.write("NODATA_value " + this.noDataValue);
            this.writer.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.values = new TreeMap<Integer, double[]>();
        this.values_d = new double[this.width];
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int x, int y, Set<Metric> metrics) {
        block21: {
            int yv;
            double v;
            block22: {
                int yv2;
                block20: {
                    v = this.metric.value();
                    if (y != 0) break block20;
                    if (x == 0) {
                        this.values.put(0, new double[this.width]);
                        this.values.get((Object)Integer.valueOf((int)0))[0] = v;
                        for (int i = 1; i < this.width; ++i) {
                            this.values.get((Object)Integer.valueOf((int)0))[i] = this.noDataValue;
                        }
                    } else {
                        this.values.get((Object)Integer.valueOf((int)0))[x] = v;
                        for (int xv = 1; xv < this.delta; ++xv) {
                            this.values.get((Object)Integer.valueOf((int)0))[x - this.delta + xv] = this.droite(this.values.get(0)[x - this.delta], v, xv);
                        }
                    }
                    break block21;
                }
                if (x != 0) break block22;
                if (y > this.delta) {
                    for (int yv3 = 1; yv3 <= this.delta; ++yv3) {
                        for (double d : this.values.get(y - 2 * this.delta + yv3)) {
                            this.write(d, y - 2 * this.delta + yv3);
                        }
                    }
                } else {
                    for (double d : this.values.get(0)) {
                        this.write(d, 0);
                    }
                }
                for (int i = 0; i < this.width; ++i) {
                    this.values_d[i] = this.values.get(y - this.delta)[i];
                }
                this.values.clear();
                for (yv2 = 1; yv2 <= this.delta; ++yv2) {
                    this.values.put(y - this.delta + yv2, new double[this.width]);
                    for (int i = 0; i < this.width; ++i) {
                        this.values.get((Object)Integer.valueOf((int)(y - this.delta + yv2)))[i] = this.noDataValue;
                    }
                }
                this.values.get((Object)Integer.valueOf((int)y))[0] = v;
                for (yv2 = 1; yv2 < this.delta; ++yv2) {
                    this.values.get((Object)Integer.valueOf((int)(y - this.delta + yv2)))[0] = this.droite(this.values_d[0], v, yv2);
                }
                break block21;
            }
            this.values.get((Object)Integer.valueOf((int)y))[x] = v;
            for (int xv = 1; xv < this.delta; ++xv) {
                this.values.get((Object)Integer.valueOf((int)y))[x - this.delta + xv] = this.droite(this.values.get(y)[x - this.delta], v, xv);
            }
            for (yv = 1; yv < this.delta; ++yv) {
                double vh;
                this.values.get((Object)Integer.valueOf((int)(y - this.delta + yv)))[x] = vh = this.droite(this.values_d[x], v, yv);
                for (int xv = 1; xv < this.delta; ++xv) {
                    this.values.get((Object)Integer.valueOf((int)(y - this.delta + yv)))[x - this.delta + xv] = this.droite(this.values.get(y - this.delta + yv)[x - this.delta], vh, xv);
                }
            }
            if (y != this.maxHeight || x != this.maxWidth) break block21;
            for (yv = 1; yv <= this.delta; ++yv) {
                for (double d : this.values.get(y - this.delta + yv)) {
                    this.write(d, y - this.delta + yv);
                }
            }
            for (int j = this.maxHeight + 1; j < this.height; ++j) {
                for (int i = 0; i < this.width; ++i) {
                    this.write(this.noDataValue, j);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Counting c, Set<Metric> metrics) {
        try {
            this.writer.newLine();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Tool.copy(DynamicLayerFactory.class.getResourceAsStream(CoverageManager.epsg()), this.file.replace(".asc", "") + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private double droite(double v_delta, double v, double yv) {
        if (v == (double)this.noDataValue || v_delta == (double)this.noDataValue) {
            return this.noDataValue;
        }
        return yv * (v - v_delta) / (double)this.delta + v_delta;
    }

    private void write(double v, int y) {
        try {
            if (this.yGlobal == -1) {
                this.writer.write(Util.format(v));
                this.yGlobal = 0;
            } else if (y != this.yGlobal) {
                this.writer.newLine();
                this.writer.write(Util.format(v));
                this.yGlobal = y;
            } else {
                this.writer.write(" " + Util.format(v));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }
}

