/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.util.Arrays;
import java.util.Set;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class InterpolateSplineGeoTiffOutput
implements CountingObserver {
    private final String file;
    private final Metric metric;
    private final float[] datas;
    private final int width;
    private final int height;
    private final int noDataValue;
    private final int delta;
    private final double outMinX;
    private final double outMaxX;
    private final double outMinY;
    private final double outMaxY;
    private final double cellSize;
    private final CoordinateReferenceSystem crs;
    private int maxI;
    private float[] line;
    private float[] oldLine;

    public InterpolateSplineGeoTiffOutput(String file, Metric metric, int width, int height, double outMinX, double outMaxX, double outMinY, double outMaxY, double cellSize, int noDataValue, CoordinateReferenceSystem crs, int displacement) {
        this.file = file;
        this.metric = metric;
        this.width = width;
        this.height = height;
        this.outMinX = outMinX;
        this.outMaxX = outMaxX;
        this.outMinY = outMinY;
        this.outMaxY = outMaxY;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.crs = crs;
        this.delta = displacement;
        this.datas = new float[height * width];
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        Arrays.fill(this.datas, (float)this.noDataValue);
        this.line = new float[this.width];
        Arrays.fill(this.line, (float)this.noDataValue);
        this.maxI = this.getMaxI(this.width, this.delta);
    }

    private int getMaxI(int w, int d) {
        return d * ((w - 1) / d);
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int i, int j, Set<Metric> metrics) {
        this.line[i] = (float)this.metric.value();
        if (i > 0) {
            int x;
            for (x = 1; x < this.delta; ++x) {
                this.line[i - this.delta + x] = Float.parseFloat(Util.format(this.droite(this.line[i - this.delta], this.line[i], x)));
            }
            if (i == this.maxI) {
                if (j != 0) {
                    for (int y = 1; y < this.delta; ++y) {
                        for (int x2 = 0; x2 < this.width; ++x2) {
                            this.datas[(j - this.delta + y) * this.width + x2] = Float.parseFloat(Util.format(this.droite(this.oldLine[x2], this.line[x2], y)));
                        }
                    }
                }
                for (x = 0; x < this.width; ++x) {
                    this.datas[j * this.width + x] = this.line[x];
                }
                this.oldLine = (float[])this.line.clone();
                Arrays.fill(this.line, (float)this.noDataValue);
            }
        }
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
        CoverageManager.writeGeotiff(this.file, this.datas, new EnteteRaster(this.width, this.height, this.outMinX, this.outMaxX, this.outMinY, this.outMaxY, (float)this.cellSize, this.noDataValue, this.crs));
    }

    private double droite(double v, double v_delta, double x) {
        if (v == (double)this.noDataValue || v_delta == (double)this.noDataValue) {
            return this.noDataValue;
        }
        return x * (v_delta - v) / (double)this.delta + v;
    }
}

