/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.util.Set;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoTiffOutput
implements CountingObserver {
    private final String file;
    private final Metric metric;
    private final float[] datas;
    private final int width;
    private final int height;
    private final int noDataValue;
    private final double outMinX;
    private final double outMaxX;
    private final double outMinY;
    private final double outMaxY;
    private final double cellSize;
    private final CoordinateReferenceSystem crs;
    private int ind;

    public GeoTiffOutput(String file, Metric metric, int width, int height, double outMinX, double outMaxX, double outMinY, double outMaxY, double cellSize, int noDataValue, CoordinateReferenceSystem crs) {
        this.file = file;
        this.metric = metric;
        this.width = width;
        this.height = height;
        this.outMinX = outMinX;
        this.outMaxX = outMaxX;
        this.outMinY = outMinY;
        this.outMaxY = outMaxY;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.crs = crs;
        this.datas = new float[height * width];
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        this.ind = 0;
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int i, int j, Set<Metric> metrics) {
        this.datas[this.ind++] = Float.parseFloat(Util.format(this.metric.value()));
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
        CoverageManager.writeGeotiff(this.file, this.datas, new EnteteRaster(this.width, this.height, this.outMinX, this.outMaxX, this.outMinY, this.outMaxY, (float)this.cellSize, this.noDataValue, this.crs));
    }
}

