/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EntityRasterOutput
implements CountingObserver {
    private final String file;
    private final Metric metric;
    private final Coverage entityCoverage;
    private final int noDataValue;
    private Map<Integer, Float> datas;

    public EntityRasterOutput(String file, Metric metric, Coverage entityCoverage, int noDataValue) {
        this.file = file;
        this.metric = metric;
        this.entityCoverage = entityCoverage;
        this.noDataValue = noDataValue;
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        Util.createAccess(this.file);
        this.datas = new HashMap<Integer, Float>();
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int x, int y, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
        this.datas.put(id, Float.valueOf(Float.parseFloat(Util.format(this.metric.value()))));
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
        float[] inData = this.entityCoverage.getData();
        EnteteRaster entete = this.entityCoverage.getEntete();
        float[] outData = new float[inData.length];
        int index = 0;
        for (float d : inData) {
            outData[index] = d == (float)this.noDataValue || d == 0.0f ? d : this.datas.get((int)d).floatValue();
            ++index;
        }
        CoverageManager.write(this.file, outData, entete);
    }
}

