/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EntityMultipleAsciiGridOutput
implements CountingObserver {
    private final String folder;
    private final Coverage entityCoverage;
    private final int width;
    private final int height;
    private final int noDataValue;
    private final double xllCorner;
    private final double yllCorner;
    private final double cellSize;
    private Map<Integer, Map<Metric, Double>> datas;

    public EntityMultipleAsciiGridOutput(String folder, Coverage entityCoverage, int width, int height, double xllCorner, double yllCorner, double cellSize, int noDataValue) {
        this.folder = folder;
        this.entityCoverage = entityCoverage;
        this.width = width;
        this.height = height;
        this.xllCorner = xllCorner;
        this.yllCorner = yllCorner;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        new File(this.folder).mkdirs();
        this.datas = new HashMap<Integer, Map<Metric, Double>>();
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int x, int y, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
        HashMap<Metric, Double> v = new HashMap<Metric, Double>();
        for (Metric m : metrics) {
            v.put(m, m.value());
        }
        this.datas.put(id, v);
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
        try {
            HashMap<String, BufferedWriter> writers = new HashMap<String, BufferedWriter>();
            HashMap<String, StringBuffer> stringBuffers = new HashMap<String, StringBuffer>();
            for (Metric m : metrics) {
                writers.put(m.getName(), new BufferedWriter(new FileWriter(this.folder + m.getName() + ".asc")));
                stringBuffers.put(m.getName(), new StringBuffer());
                ((BufferedWriter)writers.get(m.getName())).write("ncols " + this.width);
                ((BufferedWriter)writers.get(m.getName())).newLine();
                ((BufferedWriter)writers.get(m.getName())).write("nrows " + this.height);
                ((BufferedWriter)writers.get(m.getName())).newLine();
                ((BufferedWriter)writers.get(m.getName())).write("xllcorner " + this.xllCorner);
                ((BufferedWriter)writers.get(m.getName())).newLine();
                ((BufferedWriter)writers.get(m.getName())).write("yllcorner " + this.yllCorner);
                ((BufferedWriter)writers.get(m.getName())).newLine();
                ((BufferedWriter)writers.get(m.getName())).write("cellsize " + this.cellSize);
                ((BufferedWriter)writers.get(m.getName())).newLine();
                ((BufferedWriter)writers.get(m.getName())).write("NODATA_value " + this.noDataValue);
                ((BufferedWriter)writers.get(m.getName())).newLine();
            }
            Rectangle roi = new Rectangle(0, 0, this.width, this.height);
            float[] inDatas = this.entityCoverage.getData(roi);
            int index = 0;
            for (float d : inDatas) {
                if (++index % this.width == 0) {
                    index = 0;
                    for (Metric m : metrics) {
                        ((BufferedWriter)writers.get(m.getName())).newLine();
                    }
                }
                if (d == (float)this.noDataValue || d == 0.0f) {
                    for (Metric m : metrics) {
                        ((BufferedWriter)writers.get(m.getName())).write(d + " ");
                    }
                    continue;
                }
                for (Metric m : metrics) {
                    if (!this.datas.containsKey((int)d)) {
                        ((BufferedWriter)writers.get(m.getName())).write("0 ");
                        continue;
                    }
                    ((BufferedWriter)writers.get(m.getName())).write(Util.format(this.datas.get((int)d).get(m)) + " ");
                }
            }
            Object object = writers.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry ew = (Map.Entry)object.next();
                ((BufferedWriter)ew.getValue()).close();
                Tool.copy(DynamicLayerFactory.class.getResourceAsStream(CoverageManager.epsg()), this.folder + (String)ew.getKey() + ".prj");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

