/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;

public class EntityCsvOutput
implements CountingObserver {
    private BufferedWriter bw;
    private String csv;

    public EntityCsvOutput(String csv) {
        this.csv = csv;
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        try {
            this.bw = new BufferedWriter(new FileWriter(this.csv));
            this.bw.write("id");
            for (Metric m : metrics) {
                this.bw.write(";" + m.getName());
            }
            this.bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int x, int y, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
        try {
            this.bw.write(id + "");
            for (Metric m : metrics) {
                double v = m.value();
                this.bw.write(";" + Util.format(v));
            }
            this.bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
        try {
            this.bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

