/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;

public class CsvOutput2
implements CountingObserver {
    private BufferedOutputStream bout;
    private String csv;
    private double x;
    private double y;
    private double initX;
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    private final double cellSize;
    private final int width;
    private final int height;
    private final int noDataValue;

    public CsvOutput2(String csv, double minX, double maxX, double minY, double maxY, int width, int height, double cellSize, int noDataValue) {
        this.csv = csv;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        this.initX = this.x = this.minX + this.cellSize / 2.0;
        this.y = this.maxY - this.cellSize / 2.0;
        try {
            this.bout = new BufferedOutputStream(new FileOutputStream(this.csv));
            this.bout.write("X;Y".getBytes());
            for (Metric m : metrics) {
                this.bout.write((";" + m.getName()).getBytes());
            }
            this.bout.write("\n".getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writeHeader();
    }

    private void writeHeader() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.csv.replace(".csv", "_header.txt")));
            writer.write("ncols " + this.width);
            writer.newLine();
            writer.write("nrows " + this.height);
            writer.newLine();
            writer.write("xllcorner " + this.minX);
            writer.newLine();
            writer.write("yllcorner " + this.minY);
            writer.newLine();
            writer.write("cellsize " + this.cellSize);
            writer.newLine();
            writer.write("NODATA_value " + this.noDataValue);
            writer.newLine();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void prerun(Counting c) {
        try {
            this.bout.write((this.x + ";" + this.y).getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void postrun(Counting c, int i, int j, Set<Metric> metrics) {
        try {
            for (Metric m : metrics) {
                double v = m.value();
                this.bout.write((";" + Util.format(v)).getBytes());
            }
            this.bout.write("\n".getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.x + this.cellSize > this.maxX) {
            this.x = this.initX;
            this.y -= this.cellSize;
        } else {
            this.x += this.cellSize;
        }
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
        try {
            this.bout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }
}

