/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CsvOutput
implements CountingObserver {
    private BufferedWriter bw;
    private String csv;
    private double x;
    private double y;
    private double initX;
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    private final double cellSize;
    private final int width;
    private final int height;
    private final int noDataValue;
    private final CoordinateReferenceSystem crs;

    public CsvOutput(String csv, double minX, double maxX, double minY, double maxY, int width, int height, double cellSize, int noDataValue, CoordinateReferenceSystem crs) {
        this.csv = csv;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.crs = crs;
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        this.initX = this.x = this.minX + this.cellSize / 2.0;
        this.y = this.maxY - this.cellSize / 2.0;
        try {
            this.bw = new BufferedWriter(new FileWriter(this.csv));
            this.bw.write("X;Y");
            for (Metric m : metrics) {
                this.bw.write(";" + m.getName());
            }
            this.bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writeHeader();
    }

    private void writeHeader() {
        EnteteRaster entete = new EnteteRaster(this.width, this.height, this.minX, this.maxX, this.minY, this.maxY, (float)this.cellSize, this.noDataValue, this.crs);
        EnteteRaster.export(entete, this.csv.replace(".csv", "_header.txt"));
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int i, int j, Set<Metric> metrics) {
        try {
            boolean export = false;
            StringBuffer sb = new StringBuffer(this.x + ";" + this.y);
            for (Metric m : metrics) {
                double v = m.value();
                if (v != (double)this.noDataValue) {
                    export = true;
                }
                sb.append(';');
                sb.append(Util.format(v));
            }
            if (export) {
                this.bw.write(sb.toString());
                this.bw.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.x + this.cellSize > this.maxX) {
            this.x = this.initX;
            this.y -= this.cellSize;
        } else {
            this.x += this.cellSize;
        }
    }

    @Override
    public void close(Counting c, Set<Metric> metrics) {
        try {
            this.bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }
}

