/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.output;

import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;

public class AsciiGridOutput
implements CountingObserver {
    private final String file;
    private final Metric metric;
    private final int width;
    private final int height;
    private final int noDataValue;
    private final double xllCorner;
    private final double yllCorner;
    private final double cellSize;
    private BufferedWriter writer;
    private int currentWidth = 0;
    private StringBuffer sb;

    public AsciiGridOutput(String file, Metric metric, int width, int height, double xllCorner, double yllCorner, double cellSize, int noDataValue) {
        this.file = file;
        this.metric = metric;
        this.width = width;
        this.height = height;
        this.xllCorner = xllCorner;
        this.yllCorner = yllCorner;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
    }

    @Override
    public void init(Counting c, Set<Metric> metrics) {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.file));
            this.sb = new StringBuffer();
            this.writer.write("ncols " + this.width);
            this.writer.newLine();
            this.writer.write("nrows " + this.height);
            this.writer.newLine();
            this.writer.write("xllcorner " + this.xllCorner);
            this.writer.newLine();
            this.writer.write("yllcorner " + this.yllCorner);
            this.writer.newLine();
            this.writer.write("cellsize " + this.cellSize);
            this.writer.newLine();
            this.writer.write("NODATA_value " + this.noDataValue);
            this.writer.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void prerun(Counting c) {
    }

    @Override
    public void postrun(Counting c, int x, int y, Set<Metric> metrics) {
        this.sb.append(Util.format(this.metric.value()));
        this.sb.append(' ');
        ++this.currentWidth;
        if (this.currentWidth == this.width) {
            try {
                this.writer.write(this.sb.toString());
                this.writer.newLine();
                this.sb.setLength(0);
                this.currentWidth = 0;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void postrun(Counting c, int id, Set<Metric> metrics) {
    }

    @Override
    public void postrun(Counting c, Pixel p, Set<Metric> metrics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Counting c, Set<Metric> metrics) {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Tool.copy(CoverageManager.class.getResourceAsStream(CoverageManager.epsg()), this.file.replace(".asc", "") + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

