/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.metric.value;

import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.ThematicDistanceMetric;
import fr.inrae.act.bagap.chloe.window.metric.value.ValueMetric;

public class RaoQIndex
extends Metric
implements ValueMetric,
ThematicDistanceMetric {
    private float[][] distance;

    public RaoQIndex() {
        super("RaoQ");
    }

    @Override
    protected void doCalculate(Counting co) {
        if (co.validValues() > 0.0) {
            this.value = 0.0;
            for (int v1 : co.values()) {
                double p1 = co.countValue(v1) / co.validValues();
                for (int v2 : co.values()) {
                    if (v1 >= v2) continue;
                    double p2 = co.countValue(v2) / co.validValues();
                    this.value += (double)this.distance[v1][v2] * p1 * p2;
                }
            }
        }
    }

    @Override
    public void setThematicDistance(float[][] distance) {
        this.distance = distance;
    }
}

