/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.metric.couple;

import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.chloe.util.Couple;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.couple.CoupleMetric;
import fr.inrae.act.bagap.chloe.window.metric.value.ValueMetric;

public class AggregationIndexMultiple2
extends Metric
implements ValueMetric,
CoupleMetric {
    private short[] v;

    public AggregationIndexMultiple2(short[] v) {
        StringBuffer name = new StringBuffer("AI2m_");
        for (short vv : v) {
            name.append(vv);
            name.append('&');
        }
        name.deleteCharAt(name.length() - 1);
        this.setName(name.toString());
        this.v = v;
    }

    @Override
    public void doCalculate(Counting co) {
        if (co.countCouples() > 0.0) {
            int m;
            int n2;
            this.value = 0.0;
            int ai = 0;
            for (short classMetric : this.v) {
                ai += (int)co.countValue(classMetric);
            }
            int n = 1;
            while ((n2 = (int)Math.pow(n, 2.0)) != ai) {
                if (n2 > ai) {
                    n2 = (int)Math.pow(--n, 2.0);
                    break;
                }
                ++n;
            }
            int G = (m = ai - n2) == 0 ? 2 * n * (n - 1) : (m <= n ? 2 * n * (n - 1) + 2 * m - 1 : 2 * n * (n - 1) + 2 * m - 2);
            double g = 0.0;
            for (short classMetric1 : this.v) {
                for (short classMetric2 : this.v) {
                    if (classMetric1 > classMetric2) continue;
                    g += co.countCouple(Couple.getCouple(classMetric1, classMetric2));
                }
            }
            if (G != 0) {
                this.value += g / (double)G * 100.0 * ((double)ai / co.validValues());
            }
        } else {
            this.value = Raster.getNoDataValue();
        }
    }
}

