/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.metric.couple;

import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.chloe.util.Couple;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.couple.CoupleMetric;
import fr.inrae.act.bagap.chloe.window.metric.value.ValueMetric;

public class AggregationIndexMultiple
extends Metric
implements ValueMetric,
CoupleMetric {
    private short[] v;

    public AggregationIndexMultiple(short[] v) {
        StringBuffer name = new StringBuffer("AIm_");
        for (short vv : v) {
            name.append(vv);
            name.append('&');
        }
        name.deleteCharAt(name.length() - 1);
        this.setName(name.toString());
        this.v = v;
    }

    @Override
    public void doCalculate(Counting co) {
        if (co.countCouples() > 0.0) {
            this.value = 0.0;
            for (short classMetric : this.v) {
                int m;
                int n2;
                int ai = (int)co.countValue(classMetric);
                int n = 1;
                while ((n2 = (int)Math.pow(n, 2.0)) != ai) {
                    if (n2 > ai) {
                        n2 = (int)Math.pow(--n, 2.0);
                        break;
                    }
                    ++n;
                }
                int G = (m = ai - n2) == 0 ? 2 * n * (n - 1) : (m <= n ? 2 * n * (n - 1) + 2 * m - 1 : 2 * n * (n - 1) + 2 * m - 2);
                double g = co.countCouple(Couple.getCouple(classMetric, classMetric));
                if (G == 0) continue;
                this.value += g / (double)G * 100.0 * (co.countValue(classMetric) / co.validValues());
            }
        } else {
            this.value = Raster.getNoDataValue();
        }
    }
}

