/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.metric;

import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.NotExistingMetricException;
import fr.inrae.act.bagap.chloe.window.metric.QualitativeMetric;
import fr.inrae.act.bagap.chloe.window.metric.ThematicDistanceMetric;
import fr.inrae.act.bagap.chloe.window.metric.basic.BasicMetric;
import fr.inrae.act.bagap.chloe.window.metric.continuity.ContinuityMetric;
import fr.inrae.act.bagap.chloe.window.metric.couple.CoupleMetric;
import fr.inrae.act.bagap.chloe.window.metric.dispersion.DispersalMetric;
import fr.inrae.act.bagap.chloe.window.metric.erosion.DegatErosionMetric;
import fr.inrae.act.bagap.chloe.window.metric.erosion.SourceErosionMetric;
import fr.inrae.act.bagap.chloe.window.metric.patch.PatchMetric;
import fr.inrae.act.bagap.chloe.window.metric.quantitative.QuantitativeMetric;
import fr.inrae.act.bagap.chloe.window.metric.slope.SlopeMetric;
import fr.inrae.act.bagap.chloe.window.metric.value.ValueMetric;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jumpmind.symmetric.csv.CsvReader;

public class MetricManager {
    private static Map<String, String> metrics = new HashMap<String, String>();
    private static Map<String, Integer> coherences = new HashMap<String, Integer>();
    private static Set<String> processValueMetrics = new HashSet<String>();
    private static Set<String> processCoupleMetrics = new HashSet<String>();

    public static boolean hasMetric(String m) {
        for (String metric : metrics.keySet()) {
            if (!m.startsWith(metric)) continue;
            return true;
        }
        return false;
    }

    public static Metric get(String m) throws NotExistingMetricException {
        try {
            if (MetricManager.isProcessCoupleMetric(m)) {
                String metric = MetricManager.getProcessCoupleMetric(m);
                Class<?> c = Class.forName(metrics.get(metric));
                metric = m.replace(metric + "_", "");
                StringTokenizer st = new StringTokenizer(metric, "-");
                short c1 = Short.parseShort(st.nextToken());
                short c2 = Short.parseShort(st.nextToken());
                return (Metric)c.getConstructor(Short.TYPE, Short.TYPE).newInstance(c1, c2);
            }
            if (MetricManager.isProcessValueMetric(m)) {
                String metric = MetricManager.getProcessValueMetric(m);
                Class<?> c = Class.forName(metrics.get(metric));
                if ((metric = m.replace(metric + "_", "")).contains("-")) {
                    String[] s = metric.split("-");
                    short[] v = new short[s.length];
                    int i = 0;
                    for (String ss : s) {
                        v[i++] = Short.parseShort(ss);
                    }
                    return (Metric)c.getConstructor(short[].class).newInstance(new Object[]{v});
                }
                if (metric.contains("&")) {
                    String[] s = metric.split("&");
                    short[] v = new short[s.length];
                    int i = 0;
                    for (String ss : s) {
                        v[i++] = Short.parseShort(ss);
                    }
                    return (Metric)c.getConstructor(short[].class).newInstance(new Object[]{v});
                }
                short v = Short.parseShort(metric);
                return (Metric)c.getConstructor(Short.TYPE).newInstance(v);
            }
            Class<?> c = Class.forName(metrics.get(m));
            return (Metric)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private static boolean isProcessCoupleMetric(String m) {
        for (String metric : processCoupleMetrics) {
            if (!m.startsWith(metric + "_")) continue;
            return true;
        }
        return false;
    }

    private static String getProcessCoupleMetric(String m) {
        for (String metric : processCoupleMetrics) {
            if (!m.startsWith(metric)) continue;
            return metric;
        }
        throw new IllegalArgumentException();
    }

    private static boolean isProcessValueMetric(String m) {
        for (String metric : processValueMetrics) {
            if (!m.startsWith(metric + "_")) continue;
            return true;
        }
        return false;
    }

    private static String getProcessValueMetric(String m) {
        for (String metric : processValueMetrics) {
            if (!m.startsWith(metric)) continue;
            return metric;
        }
        throw new IllegalArgumentException();
    }

    public static boolean hasValueMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (!(m instanceof ValueMetric)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMetric(Set<Metric> metrics, String metric) {
        return metrics.contains(MetricManager.get(metric));
    }

    public static boolean hasOnlyValueMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (MetricManager.isOnlyValueMetric(m) || m instanceof BasicMetric) continue;
            return false;
        }
        return true;
    }

    private static boolean isOnlyValueMetric(Metric m) {
        return m instanceof ValueMetric && !(m instanceof CoupleMetric);
    }

    public static boolean hasCoupleMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (!(m instanceof CoupleMetric)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOnlyCoupleMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (MetricManager.isOnlyCoupleMetric(m) || m instanceof BasicMetric) continue;
            return false;
        }
        return true;
    }

    private static boolean isOnlyCoupleMetric(Metric m) {
        return m instanceof CoupleMetric && !(m instanceof ValueMetric);
    }

    public static boolean hasQuantitativeMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (!(m instanceof QuantitativeMetric)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOnlyBasicMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (m instanceof BasicMetric) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlyQuantitativeMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (m instanceof QuantitativeMetric || m instanceof BasicMetric) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlySlopeMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (m instanceof SlopeMetric || m instanceof BasicMetric) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlyQualitativeMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (m instanceof QualitativeMetric || m instanceof BasicMetric) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlyPatchMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (m instanceof PatchMetric || m instanceof BasicMetric) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlyContinuityMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (m instanceof ContinuityMetric || m instanceof BasicMetric) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlyDispersalMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (m instanceof DispersalMetric || m instanceof BasicMetric) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlySourceErosionMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (m instanceof SourceErosionMetric || m instanceof BasicMetric) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlyDegatErosionMetric(Set<Metric> metrics) {
        for (Metric m : metrics) {
            if (m instanceof DegatErosionMetric || m instanceof BasicMetric) continue;
            return false;
        }
        return true;
    }

    public static boolean hasCoherence(Set<Metric> metrics) {
        int ic = 0;
        for (Metric m : metrics) {
            int c = coherences.get(m.getName().split("_")[0]);
            if (ic != c && ic != 0 && c != 0) {
                return false;
            }
            ic = c;
        }
        return true;
    }

    public static Set<Integer> getCoherences(Set<Metric> metrics) {
        TreeSet<Integer> cIndex = new TreeSet<Integer>();
        for (Metric m : metrics) {
            cIndex.add(coherences.get(m.getName().split("_")[0]));
        }
        return cIndex;
    }

    public static Set<Metric> getMetricsByCoherence(Set<Metric> metrics, int coherence) {
        HashSet<Metric> cMetrics = new HashSet<Metric>();
        for (Metric m : metrics) {
            if (coherences.get(m.getName().split("_")[0]) != coherence) continue;
            cMetrics.add(m);
        }
        return cMetrics;
    }

    public static void initThematicDistanceMetric(String distanceFile, ThematicDistanceMetric metric, int[] values) {
        if (new File(distanceFile).exists()) {
            try {
                CsvReader cr = new CsvReader(distanceFile);
                cr.setDelimiter(';');
                cr.readHeaders();
                int max = -1;
                for (int h = 1; h < cr.getHeaderCount(); ++h) {
                    max = Math.max(max, Integer.parseInt(cr.getHeader(h)));
                }
                float[][] distances = new float[max + 1][max + 1];
                while (cr.readRecord()) {
                    for (int v1 : values) {
                        float d;
                        int v2 = Integer.parseInt(cr.get("distance"));
                        distances[v1][v2] = d = Float.parseFloat(cr.get(v1 + ""));
                        distances[v2][v1] = d;
                    }
                }
                cr.close();
                metric.setThematicDistance(distances);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("WARNING: Thematic distance file " + distanceFile + " doesn't exists.");
        }
    }

    static {
        CsvReader cr = null;
        BufferedReader buf = null;
        try {
            buf = new BufferedReader(new InputStreamReader(MetricManager.class.getResourceAsStream("metrics.csv")));
            cr = new CsvReader((Reader)buf);
            cr.setDelimiter(';');
            cr.readHeaders();
            while (cr.readRecord()) {
                if (cr.get("name").startsWith("#")) continue;
                metrics.put(cr.get("name"), cr.get("class"));
                coherences.put(cr.get("name"), Integer.parseInt(cr.get("coherence")));
                switch (cr.get("process")) {
                    case "value": {
                        processValueMetrics.add(cr.get("name"));
                        break;
                    }
                    case "couple": {
                        processCoupleMetrics.add(cr.get("name"));
                        break;
                    }
                }
            }
            cr.close();
            buf.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

