/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.slope;

import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;

public class SlidingSlopeKernel
extends SlidingLandscapeMetricKernel {
    private float cellSize;

    public SlidingSlopeKernel(int noDataValue, float cellSize) {
        super(3, 1, null, noDataValue, null);
        this.cellSize = cellSize;
    }

    @Override
    protected void processPixel(int x, int y, int localY) {
        if ((x - this.bufferROIXMin()) % this.displacement() == 0 && (y - this.bufferROIYMin()) % this.displacement() == 0) {
            int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
            if (!this.hasFilter() || this.filterValue((int)this.inDatas()[y * this.width() + x])) {
                this.outDatas()[ind][0] = 1.0;
                this.outDatas()[ind][1] = this.inDatas()[y * this.width() + x];
                float vc = (float)this.outDatas()[ind][1];
                for (int i = 2; i < this.outDatas()[0].length; ++i) {
                    this.outDatas()[ind][i] = 0.0;
                }
                if (vc == (float)this.noDataValue()) {
                    this.outDatas()[ind][0] = 0.0;
                } else {
                    boolean mid = true;
                    float slopeDirection = 0.0f;
                    float minSlopeIntensity = 180.0f;
                    for (int dy = -1; dy <= 1; ++dy) {
                        if (y + dy < 0 || y + dy >= this.height()) continue;
                        for (int dx = -1; dx <= 1; ++dx) {
                            float diffHauteur;
                            float diffDistance;
                            float tangente;
                            float slopeIntensity;
                            float v;
                            if (x + dx < 0 || x + dx >= this.width() || dx == 0 && dy == 0 || (v = this.inDatas()[(y + dy) * this.width() + (x + dx)]) == (float)this.noDataValue() || !((slopeIntensity = (float)((90.0 + (90.0 + Math.toDegrees(Math.atan(tangente = (diffDistance = (float)(dy == 0 || dx == 0 ? (double)this.cellSize : (double)this.cellSize * Math.sqrt(2.0))) / (diffHauteur = vc - v))))) % 180.0)) < minSlopeIntensity)) continue;
                            minSlopeIntensity = slopeIntensity;
                            if (!(tangente > 0.0f) || slopeIntensity == 90.0f || !((slopeDirection = (float)(dx + 2 + (dy + 1) * 3)) > 4.0f)) continue;
                            slopeDirection -= 1.0f;
                        }
                    }
                    this.outDatas()[ind][4] = slopeDirection;
                    this.outDatas()[ind][5] = minSlopeIntensity;
                }
            } else {
                this.outDatas()[ind][0] = 0.0;
            }
        }
    }
}

