/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.grainbocager;

import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;

public class GrainBocagerSlidingDetectionBocageKernel
extends SlidingLandscapeMetricKernel {
    private float minHauteur;

    public GrainBocagerSlidingDetectionBocageKernel(int windowSize, int displacement, float[] coeff, int noDataValue, int[] unfilters, float minHauteur) {
        super(windowSize, displacement, coeff, noDataValue, unfilters);
        this.minHauteur = minHauteur;
    }

    @Override
    protected void processPixel(int x, int y, int localY) {
        if ((x - this.bufferROIXMin()) % this.displacement() == 0 && (y - this.bufferROIYMin()) % this.displacement() == 0) {
            int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
            if (!this.hasFilter() || this.filterValue((int)this.inDatas()[y * this.width() + x])) {
                this.outDatas()[ind][0] = 1.0;
                this.outDatas()[ind][1] = this.inDatas()[y * this.width() + x];
                for (int i = 2; i < this.outDatas()[0].length; ++i) {
                    this.outDatas()[ind][i] = 0.0;
                }
                int mid = this.windowSize() / 2;
                float vCentral = this.inDatas()[y * this.width() + x];
                if (vCentral == (float)this.noDataValue()) {
                    this.outDatas()[ind][2] = 0.0;
                    this.outDatas()[ind][3] = 1.0;
                    this.outDatas()[ind][4] = this.noDataValue();
                } else if (vCentral < this.minHauteur) {
                    this.outDatas()[ind][2] = 1.0;
                    this.outDatas()[ind][3] = 0.0;
                    this.outDatas()[ind][4] = 0.0;
                } else {
                    float nb_nodata = 0.0f;
                    float nb_value = 0.0f;
                    float sum = 0.0f;
                    for (int dy = -mid; dy <= mid; ++dy) {
                        if (y + dy < 0 || y + dy >= this.height()) continue;
                        for (int dx = -mid; dx <= mid; ++dx) {
                            if (x + dx < 0 || x + dx >= this.width()) continue;
                            int ic = (dy + mid) * this.windowSize() + (dx + mid);
                            float coeff = this.coeff()[ic];
                            if (!(coeff > 0.0f)) continue;
                            float v = this.inDatas()[(y + dy) * this.width() + (x + dx)];
                            nb_value += coeff;
                            if (v == (float)this.noDataValue()) {
                                nb_nodata += coeff;
                                continue;
                            }
                            if (!(v >= this.minHauteur)) continue;
                            sum += coeff;
                        }
                    }
                    this.outDatas()[ind][2] = nb_value;
                    this.outDatas()[ind][3] = nb_nodata;
                    this.outDatas()[ind][4] = sum;
                }
            } else {
                this.outDatas()[ind][0] = 0.0;
            }
        }
    }
}

