/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.functional;

import fr.inrae.act.bagap.apiland.analysis.distance.DistanceFunction;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.functional.SlidingFunctionalKernel;

public class SlidingFunctionalCountValueKernel
extends SlidingFunctionalKernel {
    private int[] mapValues;

    public SlidingFunctionalCountValueKernel(int windowSize, int displacement, int noDataValue, int[] values, int[] unfilters, double cellSize, DistanceFunction function, double radius) {
        super(windowSize, displacement, null, noDataValue, unfilters, cellSize, function, radius);
        int maxV = 0;
        for (int v : values) {
            maxV = Math.max(v, maxV);
        }
        this.mapValues = new int[++maxV];
        for (int i = 0; i < values.length; ++i) {
            this.mapValues[values[i]] = i;
        }
    }

    @Override
    protected void processPixel(int x, int y, int localY) {
        if ((x - this.bufferROIXMin()) % this.displacement() == 0 && (y - this.bufferROIYMin()) % this.displacement() == 0) {
            int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
            if (!this.hasFilter() || this.filterValue((int)this.inDatas()[y * this.width() + x])) {
                this.outDatas()[ind][0] = 1.0;
                this.outDatas()[ind][1] = this.inDatas()[y * this.width() + x];
                for (int i = 2; i < this.outDatas()[0].length; ++i) {
                    this.outDatas()[ind][i] = 0.0;
                }
                int mid = this.windowSize() / 2;
                float[] resistance = this.generateResistance(x, y, mid);
                float[] distance = this.calculateDistance(resistance);
                this.generateCoeff(distance);
                float nb = 0.0f;
                float nb_nodata = 0.0f;
                float nb_zero = 0.0f;
                for (int dy = -mid; dy <= mid; ++dy) {
                    if (y + dy < 0 || y + dy >= this.height()) continue;
                    for (int dx = -mid; dx <= mid; ++dx) {
                        if (x + dx < 0 || x + dx >= this.width()) continue;
                        int ic = (dy + mid) * this.windowSize() + (dx + mid);
                        float coeff = this.coeff()[ic];
                        if (!(coeff > 0.0f)) continue;
                        int v = (int)this.inDatas()[(y + dy) * this.width() + (x + dx)];
                        nb += coeff;
                        if (v == this.noDataValue()) {
                            nb_nodata += coeff;
                            continue;
                        }
                        if (v == 0) {
                            nb_zero += coeff;
                            continue;
                        }
                        int mv = this.mapValues[v];
                        double[] dArray = this.outDatas()[ind];
                        int n = mv + 5;
                        dArray[n] = dArray[n] + (double)coeff;
                    }
                }
                this.outDatas()[ind][2] = nb;
                this.outDatas()[ind][3] = nb_nodata;
                this.outDatas()[ind][4] = nb_zero;
            } else {
                this.outDatas()[ind][0] = 0.0;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mapValues = null;
    }
}

