/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.functional;

import fr.inrae.act.bagap.apiland.analysis.distance.DistanceFunction;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.functional.SlidingFunctionalKernel;

public class SlidingFunctionalCountCoupleKernel
extends SlidingFunctionalKernel {
    private int[][] mapCouples;
    private int[] mapValues;

    public SlidingFunctionalCountCoupleKernel(int windowSize, int displacement, int noDataValue, int[] values, int[] unfilters, double cellSize, DistanceFunction function, double radius) {
        super(windowSize, displacement, null, noDataValue, unfilters, cellSize, function, radius);
        int maxV = 0;
        for (int v : values) {
            maxV = Math.max(v, maxV);
        }
        this.mapValues = new int[++maxV];
        for (int i = 0; i < values.length; ++i) {
            this.mapValues[values[i]] = i;
        }
        this.mapCouples = new int[values.length][values.length];
        int index = 0;
        for (int v : values) {
            this.mapCouples[this.mapValues[v]][this.mapValues[v]] = index++;
        }
        for (int v1 : values) {
            for (int v2 : values) {
                if (v1 >= v2) continue;
                this.mapCouples[this.mapValues[v1]][this.mapValues[v2]] = index;
                this.mapCouples[this.mapValues[v2]][this.mapValues[v1]] = index++;
            }
        }
    }

    @Override
    protected void processPixel(int x, int y, int localY) {
        if ((x - this.bufferROIXMin()) % this.displacement() == 0 && (y - this.bufferROIYMin()) % this.displacement() == 0) {
            int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
            if (!this.hasFilter() || this.filterValue((int)this.inDatas()[y * this.width() + x])) {
                this.outDatas()[ind][0] = 1.0;
                this.outDatas()[ind][1] = this.inDatas()[y * this.width() + x];
                for (int i = 2; i < this.outDatas()[0].length; ++i) {
                    this.outDatas()[ind][i] = 0.0;
                }
                int mid = this.windowSize() / 2;
                float[] resistance = this.generateResistance(x, y, mid);
                float[] distance = this.calculateDistance(resistance);
                this.generateCoeff(distance);
                float nb = 0.0f;
                float nb_nodata = 0.0f;
                float nbC = 0.0f;
                float nbC_nodata = 0.0f;
                float nbC_zero = 0.0f;
                for (int dy = -mid; dy <= mid; ++dy) {
                    if (y + dy < 0 || y + dy >= this.height()) continue;
                    for (int dx = -mid; dx <= mid; ++dx) {
                        int mc;
                        if (x + dx < 0 || x + dx >= this.width()) continue;
                        int ic = (dy + mid) * this.windowSize() + (dx + mid);
                        float coeff = this.coeff()[ic];
                        if (!(coeff > 0.0f)) continue;
                        short v = (short)this.inDatas()[(y + dy) * this.width() + (x + dx)];
                        nb += coeff;
                        if (v == this.noDataValue()) {
                            nb_nodata += coeff;
                        }
                        if (dy > -mid && y + dy > 0) {
                            int ic_V = (dy + mid - 1) * this.windowSize() + (dx + mid);
                            if (this.coeff()[ic_V] > 0.0f) {
                                short v_V = (short)this.inDatas()[(y + dy - 1) * this.width() + (x + dx)];
                                nbC += coeff;
                                if (v == this.noDataValue() || v_V == this.noDataValue()) {
                                    nbC_nodata += coeff;
                                } else if (v == 0 || v_V == 0) {
                                    nbC_zero += coeff;
                                } else {
                                    mc = this.mapCouples[this.mapValues[v]][this.mapValues[v_V]];
                                    double[] dArray = this.outDatas()[ind];
                                    int n = mc + 7;
                                    dArray[n] = dArray[n] + (double)coeff;
                                }
                            }
                        }
                        if (dx <= -mid || x + dx <= 0) continue;
                        int ic_H = (dy + mid) * this.windowSize() + (dx + mid - 1);
                        if (!(this.coeff()[ic_H] > 0.0f)) continue;
                        short v_H = (short)this.inDatas()[(y + dy) * this.width() + (x + dx - 1)];
                        nbC += coeff;
                        if (v == this.noDataValue() || v_H == this.noDataValue()) {
                            nbC_nodata += coeff;
                            continue;
                        }
                        if (v == 0 || v_H == 0) {
                            nbC_zero += coeff;
                            continue;
                        }
                        mc = this.mapCouples[this.mapValues[v]][this.mapValues[v_H]];
                        double[] dArray = this.outDatas()[ind];
                        int n = mc + 7;
                        dArray[n] = dArray[n] + (double)coeff;
                    }
                }
                this.outDatas()[ind][2] = nb;
                this.outDatas()[ind][3] = nb_nodata;
                this.outDatas()[ind][4] = nbC;
                this.outDatas()[ind][5] = nbC_nodata;
                this.outDatas()[ind][6] = nbC_zero;
            } else {
                this.outDatas()[ind][0] = 0.0;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mapCouples = null;
        this.mapValues = null;
    }
}

