/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.functional;

import fr.inrae.act.bagap.apiland.analysis.distance.DistanceFunction;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.functional.SlidingFunctionalKernel;

public class SlidingFunctionalContinuityKernel
extends SlidingFunctionalKernel {
    private float localSurface;

    public SlidingFunctionalContinuityKernel(int windowSize, int displacement, int noDataValue, int[] unfilters, float cellSize, DistanceFunction function, double radius) {
        super(windowSize, displacement, null, noDataValue, unfilters, cellSize, function, radius);
        this.localSurface = (float)Math.pow(cellSize, 2.0);
    }

    @Override
    protected void processPixel(int x, int y, int localY) {
        if ((x - this.bufferROIXMin()) % this.displacement() == 0 && (y - this.bufferROIYMin()) % this.displacement() == 0) {
            int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
            if (!this.hasFilter() || this.filterValue((int)this.inDatas()[y * this.width() + x])) {
                this.outDatas()[ind][0] = 1.0;
                this.outDatas()[ind][1] = this.inDatas()[y * this.width() + x];
                for (int i = 2; i < this.outDatas()[0].length; ++i) {
                    this.outDatas()[ind][i] = 0.0;
                }
                int mid = this.windowSize() / 2;
                float[] resistance = this.generateResistance(x, y, mid);
                float[] distance = this.calculateDistance(resistance);
                this.generateCoeff(distance);
                float nb_total = 0.0f;
                float nb_nodata = 0.0f;
                float surface = 0.0f;
                float volume = 0.0f;
                for (int dy = -mid; dy <= mid; ++dy) {
                    if (y + dy < 0 || y + dy >= this.height()) continue;
                    for (int dx = -mid; dx <= mid; ++dx) {
                        if (x + dx < 0 || x + dx >= this.width()) continue;
                        int ic = (dy + mid) * this.windowSize() + (dx + mid);
                        float coeff = this.coeff()[ic];
                        if (!(coeff > 0.0f)) continue;
                        int v = (int)this.inDatas()[(y + dy) * this.width() + (x + dx)];
                        nb_total += coeff;
                        if (v == this.noDataValue()) {
                            nb_nodata += coeff;
                            continue;
                        }
                        surface += coeff * this.localSurface;
                        volume = (float)((double)volume + (double)(coeff * this.localSurface) * (this.radius() - (double)distance[ic]));
                    }
                }
                this.outDatas()[ind][2] = nb_total;
                this.outDatas()[ind][3] = nb_nodata;
                this.outDatas()[ind][4] = surface;
                this.outDatas()[ind][5] = volume;
            } else {
                this.outDatas()[ind][0] = 0.0;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

