/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.fast;

import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;

public abstract class FastKernel
extends SlidingLandscapeMetricKernel {
    private float[][] buf;
    private int rayon = this.windowSize() / 2 + 1;
    private int nValuesTot;

    protected FastKernel(int windowSize, int displacement, int noDataValue, int[] unfilters) {
        super(windowSize, displacement, null, noDataValue, unfilters);
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.buf = new float[width][this.nValuesTot];
    }

    @Override
    public void applySlidingWindow(int theY, int buffer) {
        this.setTheY(theY);
        int nlines = (buffer - 1 - (this.displacement() - this.theY() % this.displacement()) % this.displacement()) / this.displacement() + 1;
        this.execute(this.width(), 2 * nlines);
    }

    @Override
    public void run() {
        int x = this.getGlobalId(0);
        int pass = this.getPassId();
        int vertical = pass % 2;
        int line = (this.displacement() - this.theY() % this.displacement()) % this.displacement() + pass / 2 * this.displacement();
        if (vertical == 0) {
            this.processVerticalPixel(x, line);
        } else if (x < (this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) {
            this.processHorizontalPixel(x, line);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.buf = null;
    }

    protected abstract void processVerticalPixel(int var1, int var2);

    protected abstract void processHorizontalPixel(int var1, int var2);

    protected abstract float coeff(int var1);

    protected void setNValuesTot(int nValuesTot) {
        this.nValuesTot = nValuesTot;
    }

    protected int nValuesTot() {
        return this.nValuesTot;
    }

    protected int rayon() {
        return this.rayon;
    }

    protected float[][] buf() {
        return this.buf;
    }
}

