/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.fast;

import fr.inrae.act.bagap.chloe.window.kernel.sliding.fast.FastQualitativeKernel;

public abstract class FastCountValueAndCoupleKernel
extends FastQualitativeKernel {
    private final int nValues;
    private int[][] mapCouples;

    public FastCountValueAndCoupleKernel(int windowSize, int displacement, int noDataValue, int[] values, int[] unfilters) {
        super(windowSize, displacement, noDataValue, values, unfilters);
        this.nValues = values.length;
        this.mapCouples = new int[values.length][values.length];
        int index = 0;
        for (int v : values) {
            this.mapCouples[this.mapValues()[v]][this.mapValues()[v]] = index++;
        }
        for (int v1 : values) {
            for (int v2 : values) {
                if (v1 >= v2) continue;
                this.mapCouples[this.mapValues()[v1]][this.mapValues()[v2]] = index;
                this.mapCouples[this.mapValues()[v2]][this.mapValues()[v1]] = index++;
            }
        }
        this.setNValuesTot(5 + values.length + 3 + index);
    }

    @Override
    protected void processVerticalPixel(int x, int line) {
        int y = this.theY() + line + this.bufferROIYMin();
        for (int i = 0; i < this.nValuesTot(); ++i) {
            this.buf()[x][i] = 0.0f;
        }
        float nb = 0.0f;
        float nb_nodata = 0.0f;
        float nb_zero = 0.0f;
        float nbC = 0.0f;
        float nbC_nodata = 0.0f;
        float nbC_zero = 0.0f;
        for (int dy = -this.rayon() + 1; dy < this.rayon(); ++dy) {
            int mc;
            if (y + dy < 0 || y + dy >= this.height()) continue;
            int v = (int)this.inDatas()[(y + dy) * this.width() + x];
            float coeff = this.coeff(dy);
            nb += coeff;
            if (v == this.noDataValue()) {
                nb_nodata += coeff;
            } else if (v == 0) {
                nb_zero += coeff;
            } else {
                int mv = this.mapValues()[v] + 5;
                float[] fArray = this.buf()[x];
                int n = mv;
                fArray[n] = fArray[n] + coeff;
            }
            if (y + dy > 0) {
                int v_V = (int)this.inDatas()[(y + dy - 1) * this.width() + x];
                nbC += coeff;
                if (v == this.noDataValue() || v_V == this.noDataValue()) {
                    nbC_nodata += coeff;
                } else if (v == 0 || v_V == 0) {
                    nbC_zero += coeff;
                } else {
                    mc = this.nValues + 8 + this.mapCouples[this.mapValues()[v]][this.mapValues()[v_V]];
                    float[] fArray = this.buf()[x];
                    int n = mc;
                    fArray[n] = fArray[n] + coeff;
                }
            }
            if (x <= 0) continue;
            int v_H = (int)this.inDatas()[(y + dy) * this.width() + x - 1];
            nbC += coeff;
            if (v == this.noDataValue() || v_H == this.noDataValue()) {
                nbC_nodata += coeff;
                continue;
            }
            if (v == 0 || v_H == 0) {
                nbC_zero += coeff;
                continue;
            }
            mc = this.nValues + 8 + this.mapCouples[this.mapValues()[v]][this.mapValues()[v_H]];
            float[] fArray = this.buf()[x];
            int n = mc;
            fArray[n] = fArray[n] + coeff;
        }
        this.buf()[x][2] = nb;
        this.buf()[x][3] = nb_nodata;
        this.buf()[x][4] = nb_zero;
        this.buf()[x][this.nValues + 5] = nbC;
        this.buf()[x][this.nValues + 6] = nbC_nodata;
        this.buf()[x][this.nValues + 7] = nbC_zero;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mapCouples = null;
    }
}

