/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.erosion;

import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.util.CoordinateManager;
import fr.inrae.act.bagap.chloe.distance.analysis.slope.TabSourceErosionAltitudeRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;
import java.util.Arrays;

public class SlidingSourceErosionKernel
extends SlidingLandscapeMetricKernel {
    private float cellSize;
    private float localSurface;
    private EnteteRaster inEntete;
    private EnteteRaster outEntete;
    private boolean interpolate;
    private String outputDegatIntensity;
    private String outputDepotIntensity;
    private float[] dataDegatIntensity;
    private float[] dataDepotIntensity;

    public SlidingSourceErosionKernel(int windowSize, int displacement, int noDataValue, int[] unfilters, EnteteRaster inEntete, EnteteRaster outEntete, boolean interpolate, String outputDegatIntensity, String outputDepotIntensity) {
        super(windowSize, displacement, null, noDataValue, unfilters);
        this.inEntete = inEntete;
        this.cellSize = inEntete.cellsize();
        this.outEntete = outEntete;
        this.localSurface = (float)Math.pow(this.cellSize, 2.0);
        this.interpolate = interpolate;
        if (outputDegatIntensity != null) {
            this.dataDegatIntensity = new float[outEntete.width() * outEntete.height()];
            Arrays.fill(this.dataDegatIntensity, 0.0f);
            this.outputDegatIntensity = outputDegatIntensity;
        }
        if (outputDepotIntensity != null) {
            this.dataDepotIntensity = new float[outEntete.width() * outEntete.height()];
            Arrays.fill(this.dataDepotIntensity, 0.0f);
            this.outputDepotIntensity = outputDepotIntensity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void processPixel(int x, int y, int localY) {
        if ((x - this.bufferROIXMin()) % this.displacement() != 0) return;
        if ((y - this.bufferROIYMin()) % this.displacement() != 0) return;
        int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
        int versement = (int)this.inDatas()[y * this.width() + x];
        if (this.hasFilter() && !this.filterValue(versement)) {
            this.outDatas()[ind][0] = 0.0;
            return;
        }
        this.outDatas()[ind][0] = 1.0;
        this.outDatas()[ind][1] = versement;
        for (int i = 2; i < this.outDatas()[0].length; ++i) {
            this.outDatas()[ind][i] = 0.0;
        }
        int mid = this.windowSize() / 2;
        float[] dataAltitude = this.generateAltitude(x, y, mid);
        float[] dataInfiltration = this.generateInfiltration(x, y, mid);
        float[] dataSlopeIntensity = this.generateSlopeIntensity(x, y, mid);
        float[] dataErosion = this.calculateErosion(dataAltitude, dataInfiltration, dataSlopeIntensity, versement);
        this.generateCoeff(dataErosion, versement);
        float nb_total = 0.0f;
        float nb_nodata = 0.0f;
        float surface = 0.0f;
        float volume = 0.0f;
        int dy = -mid;
        while (true) {
            if (dy > mid) {
                this.outDatas()[ind][2] = nb_total;
                this.outDatas()[ind][3] = nb_nodata;
                this.outDatas()[ind][4] = surface;
                this.outDatas()[ind][5] = volume;
                return;
            }
            if (y + dy >= 0 && y + dy < this.height()) {
                for (int dx = -mid; dx <= mid; ++dx) {
                    float[] fArray;
                    if (x + dx < 0 || x + dx >= this.width()) continue;
                    int ic = (dy + mid) * this.windowSize() + (dx + mid);
                    float coeff = this.coeff()[ic];
                    if (!(coeff > 0.0f)) continue;
                    int v = (int)this.inDatas()[(y + dy) * this.width() + (x + dx)];
                    nb_total += coeff;
                    if (v == this.noDataValue()) {
                        nb_nodata += coeff;
                        continue;
                    }
                    surface += coeff * this.localSurface;
                    volume += coeff * ((float)versement - dataErosion[ic]);
                    if ((y + dy) * this.width() % this.displacement() != 0 || (x + dx) % this.displacement() != 0) continue;
                    int lind = (y + dy) / this.displacement() * this.outEntete.width() + (x + dx) / this.displacement();
                    float de = dataErosion[ic];
                    if (this.outputDegatIntensity != null) {
                        fArray = this.dataDegatIntensity;
                        // MONITORENTER : this.dataDegatIntensity
                        int n = lind;
                        this.dataDegatIntensity[n] = this.dataDegatIntensity[n] + ((float)versement - de);
                        // MONITOREXIT : fArray
                    }
                    if (this.outputDepotIntensity == null) continue;
                    fArray = this.dataDepotIntensity;
                    // MONITORENTER : this.dataDepotIntensity
                    int n = lind;
                    this.dataDepotIntensity[n] = this.dataDepotIntensity[n] + de;
                    // MONITOREXIT : fArray
                }
            }
            ++dy;
        }
    }

    protected float[] generateAltitude(int x, int y, int mid) {
        return this.getLocalData(2, x, y, mid);
    }

    protected float[] generateInfiltration(int x, int y, int mid) {
        return this.getLocalData(3, x, y, mid);
    }

    protected float[] generateSlopeIntensity(int x, int y, int mid) {
        return this.getLocalData(4, x, y, mid);
    }

    protected float[] getLocalData(int covIndex, int x, int y, int mid) {
        float[] data = new float[this.windowSize() * this.windowSize()];
        Arrays.fill(data, (float)this.noDataValue());
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                data[ic] = this.inDatas(covIndex)[(y + dy) * this.width() + (x + dx)];
            }
        }
        return data;
    }

    protected float[] calculateErosion(float[] dataAltitude, float[] dataInfiltration, float[] dataSlopeIntensity, float versement) {
        float[] dataErosion = new float[this.windowSize() * this.windowSize()];
        if (versement == 0.0f) {
            Arrays.fill(dataErosion, versement + 1.0f);
        } else {
            TabSourceErosionAltitudeRCMDistanceAnalysis rcm = new TabSourceErosionAltitudeRCMDistanceAnalysis(dataErosion, dataAltitude, dataInfiltration, dataSlopeIntensity, this.windowSize(), this.windowSize(), this.cellSize, this.noDataValue(), (int)versement);
            rcm.allRun();
        }
        return dataErosion;
    }

    protected void generateCoeff(float[] dataErosion, float versement) {
        float[] coeff = new float[this.windowSize() * this.windowSize()];
        for (int ind = 0; ind < dataErosion.length; ++ind) {
            float dist = dataErosion[ind];
            coeff[ind] = dist >= 0.0f && dist <= versement ? 1.0f : 0.0f;
        }
        this.setCoeff(coeff);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.outputDegatIntensity != null) {
            if (this.displacement() > 1 && !this.interpolate) {
                CoverageManager.write(this.outputDegatIntensity, this.dataDegatIntensity, this.outEntete);
            } else if (this.displacement() > 1 && this.interpolate) {
                CoverageManager.write(this.outputDegatIntensity, Util.extend(this.dataDegatIntensity, this.outEntete, this.inEntete, this.displacement()), this.inEntete);
            } else {
                CoverageManager.write(this.outputDegatIntensity, this.dataDegatIntensity, this.inEntete);
            }
        }
        if (this.outputDepotIntensity != null) {
            if (this.displacement() > 1 && !this.interpolate) {
                CoverageManager.write(this.outputDepotIntensity, this.dataDepotIntensity, this.outEntete);
            } else if (this.displacement() > 1 && this.interpolate) {
                CoverageManager.write(this.outputDepotIntensity, Util.extend(this.dataDepotIntensity, this.outEntete, this.inEntete, this.displacement()), this.inEntete);
            } else {
                CoverageManager.write(this.outputDepotIntensity, this.dataDepotIntensity, this.inEntete);
            }
        }
    }

    private void exportTab(String output, float[] tab, int x, int y) {
        int mid = this.windowSize() / 2;
        double minx = CoordinateManager.getProjectedX(this.inEntete, x - mid) - (double)(this.inEntete.cellsize() / 2.0f);
        double maxx = CoordinateManager.getProjectedX(this.inEntete, x + mid) + (double)(this.inEntete.cellsize() / 2.0f);
        double miny = CoordinateManager.getProjectedY(this.inEntete, y - mid) + (double)(this.inEntete.cellsize() / 2.0f);
        double maxy = CoordinateManager.getProjectedY(this.inEntete, y + mid) - (double)(this.inEntete.cellsize() / 2.0f);
        EnteteRaster localEntete = new EnteteRaster(this.windowSize(), this.windowSize(), minx, maxx, miny, maxy, this.inEntete.cellsize(), this.inEntete.noDataValue());
        CoverageManager.write(output, tab, localEntete);
    }
}

