/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.erosion;

import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.util.CoordinateManager;
import fr.inrae.act.bagap.chloe.distance.analysis.slope.TabMassCumulAnalysis;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;
import java.util.Arrays;

public class SlidingMassCumulKernel
extends SlidingLandscapeMetricKernel {
    private float cellSize;
    private float localSurface;
    private EnteteRaster inEntete;
    private EnteteRaster outEntete;
    private int massInit;
    private String outputDegatIntensity;
    private float[] dataDegatIntensity;

    public SlidingMassCumulKernel(int windowSize, int displacement, int noDataValue, int[] unfilters, EnteteRaster inEntete, EnteteRaster outEntete, String outputDegatIntensity) {
        super(windowSize, displacement, null, noDataValue, unfilters);
        this.inEntete = inEntete;
        this.outEntete = outEntete;
        this.cellSize = inEntete.cellsize();
        this.localSurface = (float)Math.pow(this.cellSize, 2.0);
        if (outputDegatIntensity != null) {
            this.dataDegatIntensity = new float[outEntete.width() * outEntete.height()];
            Arrays.fill(this.dataDegatIntensity, 0.0f);
            this.outputDegatIntensity = outputDegatIntensity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void processPixel(int x, int y, int localY) {
        if ((x - this.bufferROIXMin()) % this.displacement() != 0) return;
        if ((y - this.bufferROIYMin()) % this.displacement() != 0) return;
        int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
        this.massInit = (int)this.inDatas()[y * this.width() + x];
        if (this.hasFilter() && !this.filterValue(this.massInit)) {
            this.outDatas()[ind][0] = 0.0;
            return;
        }
        this.outDatas()[ind][0] = 1.0;
        this.outDatas()[ind][1] = this.massInit;
        for (int i = 2; i < this.outDatas()[0].length; ++i) {
            this.outDatas()[ind][i] = 0.0;
        }
        int mid = this.windowSize() / 2;
        float[] dataAltitude = this.generateAltitude(x, y, mid);
        float[] dataInfiltration = this.generateInfiltration(x, y, mid);
        float[] dataSlopeIntensity = this.generateSlopeIntensity(x, y, mid);
        float[] dataMassCumul = this.calculateMassCumul(dataAltitude, dataInfiltration, dataSlopeIntensity, this.massInit);
        this.generateCoeff(dataMassCumul, this.massInit);
        float nb_total = 0.0f;
        float nb_nodata = 0.0f;
        float surface = 0.0f;
        float volume = 0.0f;
        int dy = -mid;
        while (true) {
            if (dy > mid) {
                this.outDatas()[ind][2] = nb_total;
                this.outDatas()[ind][3] = nb_nodata;
                this.outDatas()[ind][4] = surface;
                this.outDatas()[ind][5] = volume;
                return;
            }
            if (y + dy >= 0 && y + dy < this.height()) {
                for (int dx = -mid; dx <= mid; ++dx) {
                    if (x + dx < 0 || x + dx >= this.width()) continue;
                    int ic = (dy + mid) * this.windowSize() + (dx + mid);
                    float coeff = this.coeff()[ic];
                    if (!(coeff > 0.0f)) continue;
                    int v = (int)this.inDatas()[(y + dy) * this.width() + (x + dx)];
                    nb_total += coeff;
                    if (v == this.noDataValue()) {
                        nb_nodata += coeff;
                        continue;
                    }
                    surface += coeff * this.localSurface;
                    float dm = dataMassCumul[ic];
                    volume += dm;
                    int lx = CoordinateManager.getLocalX(this.outEntete, CoordinateManager.getProjectedX(this.inEntete, x + dx));
                    int ly = CoordinateManager.getLocalY(this.outEntete, CoordinateManager.getProjectedY(this.inEntete, y + dy));
                    if (lx < 0 || lx >= this.outEntete.width() || ly < 0 || ly >= this.outEntete.height()) continue;
                    int lind = ly * this.outEntete.width() + lx;
                    if (this.outputDegatIntensity == null) continue;
                    float[] fArray = this.dataDegatIntensity;
                    // MONITORENTER : this.dataDegatIntensity
                    int n = lind;
                    this.dataDegatIntensity[n] = this.dataDegatIntensity[n] + dm;
                    // MONITOREXIT : fArray
                }
            }
            ++dy;
        }
    }

    private float friction(float infiltration) {
        float friction = 1.0f + (float)(9.0 * Math.pow(infiltration, 5.0));
        return friction;
    }

    protected float[] generateMassInit(int x, int y, int mid) {
        return this.getLocalData(1, x, y, mid);
    }

    protected float[] generateAltitude(int x, int y, int mid) {
        return this.getLocalData(2, x, y, mid);
    }

    protected float[] generateInfiltration(int x, int y, int mid) {
        return this.getLocalData(3, x, y, mid);
    }

    protected float[] generateSlopeIntensity(int x, int y, int mid) {
        return this.getLocalData(4, x, y, mid);
    }

    protected float[] getLocalData(int covIndex, int x, int y, int mid) {
        float[] data = new float[this.windowSize() * this.windowSize()];
        Arrays.fill(data, (float)this.noDataValue());
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                data[ic] = this.inDatas(covIndex)[(y + dy) * this.width() + (x + dx)];
            }
        }
        return data;
    }

    protected float[] calculateMassCumul(float[] dataAltitude, float[] dataInfiltration, float[] dataSlopeIntensity, int massInit) {
        float[] dataMassCumul = new float[this.windowSize() * this.windowSize()];
        TabMassCumulAnalysis rcm = new TabMassCumulAnalysis(dataMassCumul, dataAltitude, dataInfiltration, dataSlopeIntensity, this.windowSize(), this.windowSize(), this.cellSize, this.noDataValue(), massInit);
        rcm.allRun();
        return dataMassCumul;
    }

    protected void generateCoeff(float[] dataMassCumul, float massInit) {
        float[] coeff = new float[this.windowSize() * this.windowSize()];
        for (int ind = 0; ind < dataMassCumul.length; ++ind) {
            float massCumul = dataMassCumul[ind];
            coeff[ind] = massCumul >= 0.0f && massCumul <= massInit ? 1.0f : 0.0f;
        }
        this.setCoeff(coeff);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.outputDegatIntensity != null) {
            CoverageManager.write(this.outputDegatIntensity, this.dataDegatIntensity, this.outEntete);
        }
    }

    private void exportTab(String output, float[] tab, int x, int y) {
        int mid = this.windowSize() / 2;
        double X = CoordinateManager.getProjectedX(this.inEntete, x);
        double Y = CoordinateManager.getProjectedY(this.inEntete, y);
        double minx = CoordinateManager.getProjectedX(this.inEntete, x - mid) - (double)(this.inEntete.cellsize() / 2.0f);
        double maxx = CoordinateManager.getProjectedX(this.inEntete, x + mid) + (double)(this.inEntete.cellsize() / 2.0f);
        double miny = CoordinateManager.getProjectedY(this.inEntete, y - mid) + (double)(this.inEntete.cellsize() / 2.0f);
        double maxy = CoordinateManager.getProjectedY(this.inEntete, y + mid) - (double)(this.inEntete.cellsize() / 2.0f);
        EnteteRaster localEntete = new EnteteRaster(this.windowSize(), this.windowSize(), minx, maxx, miny, maxy, this.inEntete.cellsize(), this.inEntete.noDataValue());
        CoverageManager.write(output, tab, localEntete);
    }
}

