/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.erosion;

import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.util.CoordinateManager;
import fr.inrae.act.bagap.chloe.distance.analysis.slope.TabDegatErosionAltitudeRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;
import java.util.Arrays;

public class SlidingDegatErosionAltitudeKernel
extends SlidingLandscapeMetricKernel {
    private float cellSize;
    private float localSurface;
    private EnteteRaster entete;
    private int dMax;

    public SlidingDegatErosionAltitudeKernel(int windowSize, int displacement, int noDataValue, int[] unfilters, float cellSize, EnteteRaster entete, int dMax) {
        super(windowSize, displacement, null, noDataValue, unfilters);
        this.cellSize = cellSize;
        this.localSurface = (float)Math.pow(cellSize, 2.0);
        this.entete = entete;
        this.dMax = dMax;
    }

    @Override
    protected void processPixel(int x, int y, int localY) {
        if ((x - this.bufferROIXMin()) % this.displacement() == 0 && (y - this.bufferROIYMin()) % this.displacement() == 0) {
            int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
            if (!this.hasFilter() || this.filterValue((int)this.inDatas()[y * this.width() + x])) {
                this.outDatas()[ind][0] = 1.0;
                this.outDatas()[ind][1] = this.inDatas()[y * this.width() + x];
                for (int i = 2; i < this.outDatas()[0].length; ++i) {
                    this.outDatas()[ind][i] = 0.0;
                }
                int mid = this.windowSize() / 2;
                float[] dataAltitude = this.generateAltitude(x, y, mid);
                float[] dataInfiltration = this.generateInfiltration(x, y, mid);
                float[] dataErosion = this.calculateDegatErosion(dataAltitude, dataInfiltration);
                float[] dataVersement = this.generateVersement(x, y, mid);
                this.generateCoeff(dataErosion, dataVersement);
                float nb_total = 0.0f;
                float nb_nodata = 0.0f;
                float surface = 0.0f;
                float volume = 0.0f;
                for (int dy = -mid; dy <= mid; ++dy) {
                    if (y + dy < 0 || y + dy >= this.height()) continue;
                    for (int dx = -mid; dx <= mid; ++dx) {
                        if (x + dx < 0 || x + dx >= this.width()) continue;
                        int ic = (dy + mid) * this.windowSize() + (dx + mid);
                        float coeff = this.coeff()[ic];
                        if (!(coeff > 0.0f)) continue;
                        int v = (int)this.inDatas()[(y + dy) * this.width() + (x + dx)];
                        nb_total += coeff;
                        if (v == this.noDataValue()) {
                            nb_nodata += coeff;
                            continue;
                        }
                        surface += coeff * this.localSurface;
                        volume += coeff * (dataVersement[ic] - dataErosion[ic]);
                    }
                }
                this.outDatas()[ind][2] = nb_total;
                this.outDatas()[ind][3] = nb_nodata;
                this.outDatas()[ind][4] = surface;
                this.outDatas()[ind][5] = volume;
            } else {
                this.outDatas()[ind][0] = 0.0;
            }
        }
    }

    protected float[] generateVersement(int x, int y, int mid) {
        float[] dataVersement = new float[this.windowSize() * this.windowSize()];
        Arrays.fill(dataVersement, (float)this.noDataValue());
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                dataVersement[ic] = this.inDatas()[(y + dy) * this.width() + (x + dx)];
            }
        }
        return dataVersement;
    }

    protected float[] generateAltitude(int x, int y, int mid) {
        float[] dataAltitude = new float[this.windowSize() * this.windowSize()];
        Arrays.fill(dataAltitude, (float)this.noDataValue());
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                dataAltitude[ic] = this.inDatas(2)[(y + dy) * this.width() + (x + dx)];
            }
        }
        return dataAltitude;
    }

    protected float[] generateInfiltration(int x, int y, int mid) {
        float[] dataInfiltration = new float[this.windowSize() * this.windowSize()];
        Arrays.fill(dataInfiltration, (float)this.noDataValue());
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                dataInfiltration[ic] = this.inDatas(3)[(y + dy) * this.width() + (x + dx)];
            }
        }
        return dataInfiltration;
    }

    protected float[] calculateDegatErosion(float[] dataAltitude, float[] dataInfiltration) {
        float[] dataErosion = new float[this.windowSize() * this.windowSize()];
        TabDegatErosionAltitudeRCMDistanceAnalysis rcm = new TabDegatErosionAltitudeRCMDistanceAnalysis(dataErosion, dataAltitude, dataInfiltration, this.windowSize(), this.windowSize(), this.cellSize, this.noDataValue(), this.dMax);
        rcm.allRun();
        return dataErosion;
    }

    protected void generateCoeff(float[] dataErosion, float[] dataVersement) {
        float[] coeff = new float[this.windowSize() * this.windowSize()];
        for (int ind = 0; ind < dataErosion.length; ++ind) {
            float dist = dataErosion[ind];
            coeff[ind] = dist >= 0.0f && dist <= dataVersement[ind] ? 1.0f : 0.0f;
        }
        this.setCoeff(coeff);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void exportTab(String output, float[] tab, int x, int y) {
        int mid = this.windowSize() / 2;
        double X = CoordinateManager.getProjectedX(this.entete, x);
        double Y = CoordinateManager.getProjectedY(this.entete, y);
        double minx = CoordinateManager.getProjectedX(this.entete, x - mid) - (double)(this.entete.cellsize() / 2.0f);
        double maxx = CoordinateManager.getProjectedX(this.entete, x + mid) + (double)(this.entete.cellsize() / 2.0f);
        double miny = CoordinateManager.getProjectedY(this.entete, y - mid) + (double)(this.entete.cellsize() / 2.0f);
        double maxy = CoordinateManager.getProjectedY(this.entete, y + mid) - (double)(this.entete.cellsize() / 2.0f);
        EnteteRaster localEntete = new EnteteRaster(this.windowSize(), this.windowSize(), minx, maxx, miny, maxy, this.entete.cellsize(), this.entete.noDataValue());
        CoverageManager.write(output, tab, localEntete);
    }
}

