/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.biodiversite;

import fr.inrae.act.bagap.apiland.analysis.distance.DistanceFunction;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.util.CoordinateManager;
import fr.inrae.act.bagap.chloe.distance.analysis.functional.TabRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;
import java.util.Arrays;

public class SlidingRepartitionDispersionKernel
extends SlidingLandscapeMetricKernel {
    private float cellSize;
    private float localSurface;
    private EnteteRaster inEntete;
    private EnteteRaster outEntete;
    private float[] outDataJeunes;
    private float[] outDataVieilles;
    private float[] outDataMeres;
    private float dMax;
    private DistanceFunction function;

    public SlidingRepartitionDispersionKernel(int windowSize, int displacement, int noDataValue, int[] unfilters, EnteteRaster inEntete, EnteteRaster outEntete, float[] outDataJeunes, float[] outDataVieilles, float[] outDataMeres, DistanceFunction function, float dMax) {
        super(windowSize, displacement, null, noDataValue, unfilters);
        this.inEntete = inEntete;
        this.outEntete = outEntete;
        this.cellSize = inEntete.cellsize();
        this.localSurface = (float)Math.pow(this.cellSize, 2.0);
        this.dMax = dMax;
        this.function = function;
        this.outDataJeunes = outDataJeunes;
        this.outDataVieilles = outDataVieilles;
        this.outDataMeres = outDataMeres;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void processPixel(int x, int y, int localY) {
        float volume;
        float surface;
        float nb_nodata;
        float nb_total;
        block31: {
            int lind;
            int ly;
            int lx;
            int dx;
            int dx2;
            int dy;
            boolean affected;
            double cumulProba;
            float[] dataLocalEffectif;
            float localProba;
            int ic;
            float[] dataLocalProba;
            int mid;
            int meres;
            block37: {
                int dy2;
                int vieilles;
                block33: {
                    float volumeTotal;
                    float[] dataVolumeRepartition;
                    int jeunes;
                    block32: {
                        block30: {
                            if ((x - this.bufferROIXMin()) % this.displacement() != 0) return;
                            if ((y - this.bufferROIYMin()) % this.displacement() != 0) return;
                            int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
                            jeunes = (int)this.inDatas(1)[y * this.width() + x];
                            vieilles = (int)this.inDatas(2)[y * this.width() + x];
                            meres = (int)this.inDatas(3)[y * this.width() + x];
                            int candidats = jeunes + vieilles + meres;
                            if (this.hasFilter() && !this.filterValue(candidats) || candidats <= 0) break block30;
                            this.outDatas()[ind][0] = 1.0;
                            this.outDatas()[ind][1] = candidats;
                            for (int i = 2; i < this.outDatas()[0].length; ++i) {
                                this.outDatas()[ind][i] = 0.0;
                            }
                            mid = this.windowSize() / 2;
                            float[] dataRugosite = this.getRugosite(x, y, mid);
                            float[] dataQualiteHabitat = this.getQualite(x, y, mid);
                            dataVolumeRepartition = new float[this.windowSize() * this.windowSize()];
                            volumeTotal = this.calculateVolumeRepartition(dataVolumeRepartition, dataQualiteHabitat, this.calculatePonderation(this.calculateDistance(dataRugosite)));
                            nb_total = 0.0f;
                            nb_nodata = 0.0f;
                            surface = 0.0f;
                            volume = 0.0f;
                            if (!(volumeTotal > 0.0f)) break block31;
                            dataLocalProba = new float[this.windowSize() * this.windowSize()];
                            break block32;
                        }
                        this.outDatas()[ind][0] = 0.0;
                        return;
                    }
                    for (int dy3 = -mid; dy3 <= mid; ++dy3) {
                        if (y + dy3 < 0 || y + dy3 >= this.height()) continue;
                        for (int dx3 = -mid; dx3 <= mid; ++dx3) {
                            float vl;
                            if (x + dx3 < 0 || x + dx3 >= this.width() || (vl = dataVolumeRepartition[ic = (dy3 + mid) * this.windowSize() + (dx3 + mid)]) == (float)this.noDataValue()) continue;
                            nb_total += 1.0f;
                            surface += this.localSurface;
                            volume += volumeTotal;
                            dataLocalProba[ic] = localProba = vl / volumeTotal;
                        }
                    }
                    dataLocalEffectif = new float[this.windowSize() * this.windowSize()];
                    if (jeunes <= 0) break block33;
                    int c2 = 1;
                    block9: while (true) {
                        if (c2 > jeunes) {
                            float[] c2 = this.outDataJeunes;
                            // MONITORENTER : this.outDataJeunes
                            break;
                        }
                        double r = Math.random();
                        cumulProba = 0.0;
                        affected = false;
                        dy = -mid;
                        while (true) {
                            block35: {
                                block36: {
                                    block34: {
                                        if (dy > mid || affected) break block34;
                                        if (y + dy < 0 || y + dy >= this.height()) break block35;
                                        break block36;
                                    }
                                    ++c2;
                                    continue block9;
                                }
                                for (dx2 = -mid; dx2 <= mid && !affected; ++dx2) {
                                    if (x + dx2 < 0 || x + dx2 >= this.width() || !((localProba = dataLocalProba[ic = (dy + mid) * this.windowSize() + (dx2 + mid)]) > 0.0f)) continue;
                                    if (r >= cumulProba && r < cumulProba + (double)localProba) {
                                        int n = ic;
                                        dataLocalEffectif[n] = dataLocalEffectif[n] + 1.0f;
                                        affected = true;
                                        continue;
                                    }
                                    cumulProba += (double)localProba;
                                }
                            }
                            ++dy;
                        }
                        break;
                    }
                    for (dy2 = -mid; dy2 <= mid; ++dy2) {
                        if (y + dy2 < 0 || y + dy2 >= this.height()) continue;
                        for (dx = -mid; dx <= mid; ++dx) {
                            if (x + dx < 0 || x + dx >= this.width()) continue;
                            ic = (dy2 + mid) * this.windowSize() + (dx + mid);
                            lx = CoordinateManager.getLocalX(this.outEntete, CoordinateManager.getProjectedX(this.inEntete, x + dx));
                            ly = CoordinateManager.getLocalY(this.outEntete, CoordinateManager.getProjectedY(this.inEntete, y + dy2));
                            if (lx < 0 || lx >= this.outEntete.width() || ly < 0 || ly >= this.outEntete.height()) continue;
                            int n = lind = ly * this.outEntete.width() + lx;
                            this.outDataJeunes[n] = this.outDataJeunes[n] + dataLocalEffectif[ic];
                        }
                    }
                    // MONITOREXIT : c2
                }
                if (vieilles <= 0) break block37;
                Arrays.fill(dataLocalEffectif, 0.0f);
                int c3 = 1;
                block14: while (true) {
                    if (c3 > vieilles) {
                        float[] c3 = this.outDataVieilles;
                        // MONITORENTER : this.outDataVieilles
                        break;
                    }
                    double r = Math.random();
                    cumulProba = 0.0;
                    affected = false;
                    dy = -mid;
                    while (true) {
                        block39: {
                            block40: {
                                block38: {
                                    if (dy > mid || affected) break block38;
                                    if (y + dy < 0 || y + dy >= this.height()) break block39;
                                    break block40;
                                }
                                ++c3;
                                continue block14;
                            }
                            for (dx2 = -mid; dx2 <= mid && !affected; ++dx2) {
                                if (x + dx2 < 0 || x + dx2 >= this.width() || !((localProba = dataLocalProba[ic = (dy + mid) * this.windowSize() + (dx2 + mid)]) > 0.0f)) continue;
                                if (r >= cumulProba && r < cumulProba + (double)localProba) {
                                    int n = ic;
                                    dataLocalEffectif[n] = dataLocalEffectif[n] + 1.0f;
                                    affected = true;
                                    continue;
                                }
                                cumulProba += (double)localProba;
                            }
                        }
                        ++dy;
                    }
                    break;
                }
                for (dy2 = -mid; dy2 <= mid; ++dy2) {
                    if (y + dy2 < 0 || y + dy2 >= this.height()) continue;
                    for (dx = -mid; dx <= mid; ++dx) {
                        if (x + dx < 0 || x + dx >= this.width()) continue;
                        ic = (dy2 + mid) * this.windowSize() + (dx + mid);
                        lx = CoordinateManager.getLocalX(this.outEntete, CoordinateManager.getProjectedX(this.inEntete, x + dx));
                        ly = CoordinateManager.getLocalY(this.outEntete, CoordinateManager.getProjectedY(this.inEntete, y + dy2));
                        if (lx < 0 || lx >= this.outEntete.width() || ly < 0 || ly >= this.outEntete.height()) continue;
                        int n = lind = ly * this.outEntete.width() + lx;
                        this.outDataVieilles[n] = this.outDataVieilles[n] + dataLocalEffectif[ic];
                    }
                }
                // MONITOREXIT : c3
            }
            if (meres <= 0) break block31;
            Arrays.fill(dataLocalEffectif, 0.0f);
            int c = 1;
            block19: while (true) {
                if (c > meres) {
                    float[] fArray = this.outDataMeres;
                    // MONITORENTER : this.outDataMeres
                    break;
                }
                double r = Math.random();
                cumulProba = 0.0;
                affected = false;
                dy = -mid;
                while (true) {
                    block42: {
                        block43: {
                            block41: {
                                if (dy > mid || affected) break block41;
                                if (y + dy < 0 || y + dy >= this.height()) break block42;
                                break block43;
                            }
                            ++c;
                            continue block19;
                        }
                        for (dx2 = -mid; dx2 <= mid && !affected; ++dx2) {
                            if (x + dx2 < 0 || x + dx2 >= this.width() || !((localProba = dataLocalProba[ic = (dy + mid) * this.windowSize() + (dx2 + mid)]) > 0.0f)) continue;
                            if (r >= cumulProba && r < cumulProba + (double)localProba) {
                                int n = ic;
                                dataLocalEffectif[n] = dataLocalEffectif[n] + 1.0f;
                                affected = true;
                                continue;
                            }
                            cumulProba += (double)localProba;
                        }
                    }
                    ++dy;
                }
                break;
            }
            for (int dy4 = -mid; dy4 <= mid; ++dy4) {
                if (y + dy4 < 0 || y + dy4 >= this.height()) continue;
                for (dx = -mid; dx <= mid; ++dx) {
                    if (x + dx < 0 || x + dx >= this.width()) continue;
                    ic = (dy4 + mid) * this.windowSize() + (dx + mid);
                    lx = CoordinateManager.getLocalX(this.outEntete, CoordinateManager.getProjectedX(this.inEntete, x + dx));
                    ly = CoordinateManager.getLocalY(this.outEntete, CoordinateManager.getProjectedY(this.inEntete, y + dy4));
                    if (lx < 0 || lx >= this.outEntete.width() || ly < 0 || ly >= this.outEntete.height()) continue;
                    int n = lind = ly * this.outEntete.width() + lx;
                    this.outDataMeres[n] = this.outDataMeres[n] + dataLocalEffectif[ic];
                }
            }
            // MONITOREXIT : fArray
        }
        this.outDatas()[ind][2] = nb_total;
        this.outDatas()[ind][3] = nb_nodata;
        this.outDatas()[ind][4] = surface;
        this.outDatas()[ind][5] = volume;
    }

    protected float[] getRugosite(int x, int y, int mid) {
        return this.getLocalData(4, x, y, mid);
    }

    protected float[] getQualite(int x, int y, int mid) {
        return this.getLocalData(5, x, y, mid);
    }

    protected float[] getLocalData(int covIndex, int x, int y, int mid) {
        float[] data = new float[this.windowSize() * this.windowSize()];
        Arrays.fill(data, (float)this.noDataValue());
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                data[ic] = this.inDatas(covIndex)[(y + dy) * this.width() + (x + dx)];
            }
        }
        return data;
    }

    protected float[] calculateDistance(float[] rugosite) {
        float[] distance = new float[this.windowSize() * this.windowSize()];
        TabRCMDistanceAnalysis rcm = new TabRCMDistanceAnalysis(distance, rugosite, this.windowSize(), this.windowSize(), this.cellSize, this.noDataValue(), this.dMax);
        rcm.allRun();
        return distance;
    }

    protected float[] calculatePonderation(float[] distance) {
        float[] ponderation = new float[this.windowSize() * this.windowSize()];
        for (int ind = 0; ind < distance.length; ++ind) {
            float dist = distance[ind];
            if (dist >= 0.0f && dist <= this.dMax) {
                if (this.function == null) {
                    ponderation[ind] = 1.0f;
                    continue;
                }
                ponderation[ind] = (float)Math.exp(-1.0 * Math.pow(dist, 2.0) / Math.pow(this.dMax / 2.0f, 2.0));
                continue;
            }
            ponderation[ind] = 0.0f;
        }
        return ponderation;
    }

    protected float calculateVolumeRepartition(float[] dataVolumeRepartition, float[] dataQualiteHabitat, float[] dataPonderation) {
        float volumeTotal = 0.0f;
        for (int i = 0; i < dataVolumeRepartition.length; ++i) {
            float ponderation = dataPonderation[i];
            if (ponderation > 0.0f) {
                float vl = ponderation * (float)Math.pow(dataQualiteHabitat[i], 2.0);
                volumeTotal += vl;
                dataVolumeRepartition[i] = vl;
                continue;
            }
            dataVolumeRepartition[i] = this.noDataValue();
        }
        return volumeTotal;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void exportTab(String output, float[] tab, int x, int y) {
        int mid = this.windowSize() / 2;
        double X = CoordinateManager.getProjectedX(this.inEntete, x);
        double Y = CoordinateManager.getProjectedY(this.inEntete, y);
        double minx = CoordinateManager.getProjectedX(this.inEntete, x - mid) - (double)(this.inEntete.cellsize() / 2.0f);
        double maxx = CoordinateManager.getProjectedX(this.inEntete, x + mid) + (double)(this.inEntete.cellsize() / 2.0f);
        double miny = CoordinateManager.getProjectedY(this.inEntete, y - mid) + (double)(this.inEntete.cellsize() / 2.0f);
        double maxy = CoordinateManager.getProjectedY(this.inEntete, y + mid) - (double)(this.inEntete.cellsize() / 2.0f);
        EnteteRaster localEntete = new EnteteRaster(this.windowSize(), this.windowSize(), minx, maxx, miny, maxy, this.inEntete.cellsize(), this.inEntete.noDataValue());
        CoverageManager.write(output, tab, localEntete);
    }
}

