/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding.biodiversite;

import fr.inrae.act.bagap.apiland.analysis.distance.DistanceFunction;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.util.CoordinateManager;
import fr.inrae.act.bagap.chloe.distance.analysis.functional.TabRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;
import java.util.Arrays;

public class SlidingDispersionKernel
extends SlidingLandscapeMetricKernel {
    private float cellSize;
    private float localSurface;
    private EnteteRaster inEntete;
    private EnteteRaster outEntete;
    private String outputEffectifs;
    private float[] dataEffectifs;
    private float dMax;
    private DistanceFunction function;

    public SlidingDispersionKernel(int windowSize, int displacement, int noDataValue, int[] unfilters, EnteteRaster inEntete, EnteteRaster outEntete, String outputEffectifs, DistanceFunction function, float dMax) {
        super(windowSize, displacement, null, noDataValue, unfilters);
        this.inEntete = inEntete;
        this.outEntete = outEntete;
        this.cellSize = inEntete.cellsize();
        this.localSurface = (float)Math.pow(this.cellSize, 2.0);
        this.dMax = dMax;
        this.function = function;
        if (outputEffectifs != null) {
            this.dataEffectifs = new float[outEntete.width() * outEntete.height()];
            Arrays.fill(this.dataEffectifs, 0.0f);
            this.outputEffectifs = outputEffectifs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void processPixel(int x, int y, int localY) {
        float[] effectifsLocaux;
        float volume;
        float surface;
        float nb_nodata;
        float nb_total;
        float[] dataVolumeRepartition;
        block7: {
            float volumeTotal;
            int mid;
            float candidats;
            block8: {
                block6: {
                    if ((x - this.bufferROIXMin()) % this.displacement() != 0) return;
                    if ((y - this.bufferROIYMin()) % this.displacement() != 0) return;
                    int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
                    candidats = this.inDatas()[y * this.width() + x];
                    if (this.hasFilter() && !this.filterValue((int)candidats) || !(candidats > 0.0f)) break block6;
                    this.outDatas()[ind][0] = 1.0;
                    this.outDatas()[ind][1] = candidats;
                    for (int i = 2; i < this.outDatas()[0].length; ++i) {
                        this.outDatas()[ind][i] = 0.0;
                    }
                    mid = this.windowSize() / 2;
                    float[] dataRugosite = this.generateRugosite(x, y, mid);
                    float[] dataQualiteHabitat = this.generateQualiteHabitat(x, y, mid);
                    float[] dataCapaciteAccueil = this.generateCapaciteAccueil(x, y, mid);
                    float[] dataDistance = this.calculateDistance(dataRugosite);
                    float[] dataPonderation = this.calculatePonderation(x, y, dataDistance);
                    dataVolumeRepartition = new float[this.windowSize() * this.windowSize()];
                    volumeTotal = this.calculateVolumeRepartition(dataVolumeRepartition, dataQualiteHabitat, dataCapaciteAccueil, dataPonderation);
                    nb_total = 0.0f;
                    nb_nodata = 0.0f;
                    surface = 0.0f;
                    volume = 0.0f;
                    effectifsLocaux = new float[this.windowSize() * this.windowSize()];
                    if (!(volumeTotal > 0.0f)) break block7;
                    break block8;
                }
                this.outDatas()[ind][0] = 0.0;
                return;
            }
            for (int dy = -mid; dy <= mid; ++dy) {
                if (y + dy < 0 || y + dy >= this.height()) continue;
                for (int dx = -mid; dx <= mid; ++dx) {
                    float effectifLocal;
                    int ic;
                    float vl;
                    if (x + dx < 0 || x + dx >= this.width() || (vl = dataVolumeRepartition[ic = (dy + mid) * this.windowSize() + (dx + mid)]) == (float)this.noDataValue()) continue;
                    nb_total += 1.0f;
                    surface += this.localSurface;
                    volume += volumeTotal;
                    effectifsLocaux[ic] = effectifLocal = candidats * vl / volumeTotal;
                    int lx = CoordinateManager.getLocalX(this.outEntete, CoordinateManager.getProjectedX(this.inEntete, x + dx));
                    int ly = CoordinateManager.getLocalY(this.outEntete, CoordinateManager.getProjectedY(this.inEntete, y + dy));
                    if (lx < 0 || lx >= this.outEntete.width() || ly < 0 || ly >= this.outEntete.height()) continue;
                    int lind = ly * this.outEntete.width() + lx;
                    if (this.outputEffectifs == null) continue;
                    float[] fArray = this.dataEffectifs;
                    // MONITORENTER : this.dataEffectifs
                    int n = lind;
                    this.dataEffectifs[n] = this.dataEffectifs[n] + effectifLocal;
                    // MONITOREXIT : fArray
                }
            }
        }
        if ((x == 500 || x == 570 || x == 600 || x == 610) && y == 500) {
            this.exportTab("C:/Data/projet/bannwart/data/dispersion_locale/disperion_locale_" + x + "_" + y + ".tif", dataVolumeRepartition, x, y);
            this.exportTab("C:/Data/projet/bannwart/data/dispersion_locale/repartition_effectifs_locaux_" + x + "_" + y + ".tif", effectifsLocaux, x, y);
        }
        this.outDatas()[ind][2] = nb_total;
        this.outDatas()[ind][3] = nb_nodata;
        this.outDatas()[ind][4] = surface;
        this.outDatas()[ind][5] = volume;
    }

    protected float[] generateCandidat(int x, int y, int mid) {
        return this.getLocalData(1, x, y, mid);
    }

    protected float[] generateRugosite(int x, int y, int mid) {
        return this.getLocalData(2, x, y, mid);
    }

    protected float[] generateQualiteHabitat(int x, int y, int mid) {
        return this.getLocalData(3, x, y, mid);
    }

    protected float[] generateCapaciteAccueil(int x, int y, int mid) {
        return this.getLocalData(4, x, y, mid);
    }

    protected float[] getLocalData(int covIndex, int x, int y, int mid) {
        float[] data = new float[this.windowSize() * this.windowSize()];
        Arrays.fill(data, (float)this.noDataValue());
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                data[ic] = this.inDatas(covIndex)[(y + dy) * this.width() + (x + dx)];
            }
        }
        return data;
    }

    protected float[] calculateDistance(float[] rugosite) {
        float[] distance = new float[this.windowSize() * this.windowSize()];
        TabRCMDistanceAnalysis rcm = new TabRCMDistanceAnalysis(distance, rugosite, this.windowSize(), this.windowSize(), this.cellSize, this.noDataValue(), this.dMax);
        rcm.allRun();
        return distance;
    }

    protected float[] calculatePonderation(int x, int y, float[] distance) {
        float[] ponderation = new float[this.windowSize() * this.windowSize()];
        for (int ind = 0; ind < distance.length; ++ind) {
            float dist = distance[ind];
            if (dist >= 0.0f && dist <= this.dMax) {
                if (this.function == null) {
                    ponderation[ind] = 1.0f;
                    continue;
                }
                ponderation[ind] = (float)Math.exp(-1.0 * Math.pow(dist, 2.0) / Math.pow(this.dMax / 2.0f, 2.0));
                continue;
            }
            ponderation[ind] = 0.0f;
        }
        return ponderation;
    }

    protected float calculateVolumeRepartition(float[] dataVolumeRepartition, float[] dataQualiteHabitat, float[] dataCapaciteAccueil, float[] dataPonderation) {
        float volumeTotal = 0.0f;
        for (int i = 0; i < dataVolumeRepartition.length; ++i) {
            float ponderation = dataPonderation[i];
            if (ponderation > 0.0f) {
                float vl = ponderation * dataQualiteHabitat[i] * dataCapaciteAccueil[i];
                volumeTotal += vl;
                dataVolumeRepartition[i] = vl;
                continue;
            }
            dataVolumeRepartition[i] = this.noDataValue();
        }
        return volumeTotal;
    }

    @Override
    public void dispose() {
        if (this.outputEffectifs != null) {
            for (int i = 0; i < this.outEntete.width() * this.outEntete.height(); ++i) {
                if (this.inDatas(1)[i] != (float)this.noDataValue()) continue;
                this.dataEffectifs[i] = this.noDataValue();
            }
            CoverageManager.write(this.outputEffectifs, this.dataEffectifs, this.outEntete);
        }
        this.dataEffectifs = null;
        super.dispose();
    }

    private void exportTab(String output, float[] tab, int x, int y) {
        int mid = this.windowSize() / 2;
        double X = CoordinateManager.getProjectedX(this.inEntete, x);
        double Y = CoordinateManager.getProjectedY(this.inEntete, y);
        double minx = CoordinateManager.getProjectedX(this.inEntete, x - mid) - (double)(this.inEntete.cellsize() / 2.0f);
        double maxx = CoordinateManager.getProjectedX(this.inEntete, x + mid) + (double)(this.inEntete.cellsize() / 2.0f);
        double miny = CoordinateManager.getProjectedY(this.inEntete, y - mid) + (double)(this.inEntete.cellsize() / 2.0f);
        double maxy = CoordinateManager.getProjectedY(this.inEntete, y + mid) - (double)(this.inEntete.cellsize() / 2.0f);
        EnteteRaster localEntete = new EnteteRaster(this.windowSize(), this.windowSize(), minx, maxx, miny, maxy, this.inEntete.cellsize(), this.inEntete.noDataValue());
        CoverageManager.write(output, tab, localEntete);
    }
}

