/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding;

import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;

public class SlidingQuantitativeKernel
extends SlidingLandscapeMetricKernel {
    private final float threshold;

    public SlidingQuantitativeKernel(int windowSize, int displacement, float[] coeff, int noDataValue, int[] unfilters) {
        this(windowSize, displacement, coeff, noDataValue, -1.0f, unfilters);
    }

    public SlidingQuantitativeKernel(int windowSize, int displacement, float[] coeff, int noDataValue, float threshold, int[] unfilters) {
        super(windowSize, displacement, coeff, noDataValue, unfilters);
        this.threshold = threshold;
    }

    @Override
    protected void processPixel(int x, int y, int localY) {
        if ((x - this.bufferROIXMin()) % this.displacement() == 0 && (y - this.bufferROIYMin()) % this.displacement() == 0) {
            int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
            if (!this.hasFilter() || this.filterValue((int)this.inDatas()[y * this.width() + x])) {
                this.outDatas()[ind][0] = 1.0;
                this.outDatas()[ind][1] = this.inDatas()[y * this.width() + x];
                for (int i = 2; i < this.outDatas()[0].length; ++i) {
                    this.outDatas()[ind][i] = 0.0;
                }
                int mid = this.windowSize() / 2;
                float nb = 0.0f;
                float nb_nodata = 0.0f;
                float sum = 0.0f;
                float square_sum = 0.0f;
                float min = Float.MAX_VALUE;
                float max = Float.MIN_VALUE;
                if (this.threshold != -1.0f) {
                    for (int dy = -mid; dy <= mid; ++dy) {
                        if (y + dy < 0 || y + dy >= this.height()) continue;
                        for (int dx = -mid; dx <= mid; ++dx) {
                            if (x + dx < 0 || x + dx >= this.width()) continue;
                            int ic = (dy + mid) * this.windowSize() + (dx + mid);
                            float coeff = this.coeff()[ic];
                            if (!(coeff > 0.0f)) continue;
                            float v = this.inDatas()[(y + dy) * this.width() + (x + dx)];
                            nb += coeff;
                            if (v == (float)this.noDataValue()) {
                                nb_nodata += coeff;
                                continue;
                            }
                            if (v > this.threshold) {
                                sum += this.threshold * coeff;
                                square_sum += this.threshold * coeff * this.threshold * coeff;
                                min = Math.min(min, this.threshold * coeff);
                                max = Math.max(max, this.threshold * coeff);
                                continue;
                            }
                            sum += v * coeff;
                            square_sum += v * coeff * v * coeff;
                            min = Math.min(min, v * coeff);
                            max = Math.max(max, v * coeff);
                        }
                    }
                } else {
                    for (int dy = -mid; dy <= mid; ++dy) {
                        if (y + dy < 0 || y + dy >= this.height()) continue;
                        for (int dx = -mid; dx <= mid; ++dx) {
                            if (x + dx < 0 || x + dx >= this.width()) continue;
                            int ic = (dy + mid) * this.windowSize() + (dx + mid);
                            float coeff = this.coeff()[ic];
                            if (!(coeff > 0.0f)) continue;
                            float v = this.inDatas()[(y + dy) * this.width() + (x + dx)];
                            nb += coeff;
                            if (v == (float)this.noDataValue()) {
                                nb_nodata += coeff;
                                continue;
                            }
                            sum += v * coeff;
                            square_sum += v * coeff * v * coeff;
                            min = Math.min(min, v * coeff);
                            max = Math.max(max, v * coeff);
                        }
                    }
                }
                this.outDatas()[ind][2] = nb;
                this.outDatas()[ind][3] = nb_nodata;
                this.outDatas()[ind][4] = sum;
                this.outDatas()[ind][5] = square_sum;
                this.outDatas()[ind][6] = min;
                this.outDatas()[ind][7] = max;
            } else {
                this.outDatas()[ind][0] = 0.0;
            }
        }
    }
}

