/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding;

import fr.inrae.act.bagap.chloe.cluster.TabClusteringOutput;
import fr.inrae.act.bagap.chloe.cluster.chess.TabQueenDiscreteClusteringAnalysis;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;

public class SlidingPatchKernel
extends SlidingLandscapeMetricKernel {
    private int[] values;
    private double cellSize;

    public SlidingPatchKernel(int windowSize, int displacement, float[] coeff, int noDataValue, int[] values, double cellSize, int[] unfilters) {
        super(windowSize, displacement, coeff, noDataValue, unfilters);
        this.values = values;
        this.cellSize = cellSize;
    }

    @Override
    protected void processPixel(int x, int y, int localY) {
        if ((x - this.bufferROIXMin()) % this.displacement() == 0 && (y - this.bufferROIYMin()) % this.displacement() == 0) {
            int ind = (localY - this.bufferROIYMin()) / this.displacement() * ((this.width() - this.bufferROIXMin() - this.bufferROIXMax() - 1) / this.displacement() + 1) + (x - this.bufferROIXMin()) / this.displacement();
            if (!this.hasFilter() || this.filterValue((int)this.inDatas()[y * this.width() + x])) {
                int i;
                this.outDatas()[ind][0] = 1.0;
                this.outDatas()[ind][1] = this.inDatas()[y * this.width() + x];
                for (int i2 = 2; i2 < this.outDatas()[0].length; ++i2) {
                    this.outDatas()[ind][i2] = 0.0;
                }
                int mid = this.windowSize() / 2;
                float nb = 0.0f;
                float nb_nodata = 0.0f;
                float[] tabCover = new float[this.windowSize() * this.windowSize()];
                for (int dy = -mid; dy <= mid; ++dy) {
                    if (y + dy < 0 || y + dy >= this.height()) continue;
                    for (int dx = -mid; dx <= mid; ++dx) {
                        if (x + dx < 0 || x + dx >= this.width()) continue;
                        int ic = (dy + mid) * this.windowSize() + (dx + mid);
                        float coeff = this.coeff()[ic];
                        if (!(coeff > 0.0f)) continue;
                        int v = (int)this.inDatas()[(y + dy) * this.width() + (x + dx)];
                        nb += coeff;
                        if (v == this.noDataValue()) {
                            nb_nodata += coeff;
                        }
                        tabCover[(dy + mid) * this.windowSize() + (dx + mid)] = v;
                    }
                }
                TabQueenDiscreteClusteringAnalysis ca = new TabQueenDiscreteClusteringAnalysis(tabCover, this.windowSize(), this.windowSize(), this.values, this.noDataValue());
                float[] tabCluster = (float[])ca.allRun();
                TabClusteringOutput cto = new TabClusteringOutput(tabCluster, tabCover, this.values, this.cellSize, this.noDataValue());
                cto.allRun();
                this.outDatas()[ind][2] = nb;
                this.outDatas()[ind][3] = nb_nodata;
                this.outDatas()[ind][4] = cto.getNbPatch();
                this.outDatas()[ind][5] = (float)cto.getTotalSurface();
                this.outDatas()[ind][6] = (float)cto.getMaxSurface();
                this.outDatas()[ind][7] = (float)cto.getTotalSurfaceCarre();
                for (i = 0; i < this.values.length; ++i) {
                    this.outDatas()[ind][i + 8] = cto.getNbPatch(this.values[i]);
                }
                for (i = 0; i < this.values.length; ++i) {
                    this.outDatas()[ind][i + 8 + this.values.length] = (float)cto.getTotalSurface(this.values[i]);
                }
                for (i = 0; i < this.values.length; ++i) {
                    this.outDatas()[ind][i + 8 + 2 * this.values.length] = (float)cto.getMaxSurface(this.values[i]);
                }
                for (i = 0; i < this.values.length; ++i) {
                    this.outDatas()[ind][i + 8 + 3 * this.values.length] = (float)cto.getTotalSurfaceCarre(this.values[i]);
                }
            } else {
                this.outDatas()[ind][0] = 0.0;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.values = null;
    }
}

