/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.sliding;

import com.aparapi.Kernel;
import fr.inrae.act.bagap.chloe.window.kernel.LandscapeMetricKernel;

public abstract class SlidingLandscapeMetricKernel
extends Kernel
implements LandscapeMetricKernel {
    private final int windowSize;
    private final int displacement;
    private float[] coeff;
    private final int noDataValue;
    private float[][] inDatas;
    private double[][] outDatas;
    private int theY;
    private int width;
    private int height;
    private int bufferROIXMin;
    private int bufferROIXMax;
    private int bufferROIYMin;
    private int bufferROIYMax;
    private int[] unfilters;

    protected SlidingLandscapeMetricKernel(int windowSize, int displacement, float[] coeff, int noDataValue, int[] unfilters) {
        this.setExplicit(true);
        this.setExecutionModeWithoutFallback(Kernel.EXECUTION_MODE.JTP);
        this.windowSize = windowSize;
        this.displacement = displacement;
        this.coeff = coeff;
        this.noDataValue = noDataValue;
        this.unfilters = unfilters;
    }

    public void applySlidingWindow(int theY, int buffer) {
        this.theY = theY;
        this.execute((this.width - this.bufferROIXMin - this.bufferROIXMax) * buffer);
    }

    public void run() {
        int x = this.bufferROIXMin() + this.getGlobalId(0) % (this.width() - this.bufferROIXMin() - this.bufferROIXMax());
        int y = this.bufferROIYMin() + this.getGlobalId(0) / (this.width() - this.bufferROIXMin() - this.bufferROIXMax());
        this.processPixel(x, this.theY() + y, y);
    }

    protected void processPixel(int x, int y, int localY) {
    }

    protected boolean hasFilter() {
        return this.unfilters != null;
    }

    protected boolean filterValue(int f) {
        for (int uf : this.unfilters) {
            if (uf != f) continue;
            return false;
        }
        return true;
    }

    public int windowSize() {
        return this.windowSize;
    }

    protected int displacement() {
        return this.displacement;
    }

    protected void setCoeff(float[] coeff) {
        this.coeff = coeff;
    }

    protected float[] coeff() {
        return this.coeff;
    }

    protected int noDataValue() {
        return this.noDataValue;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setBufferROIXMin(int bufferROIXMin) {
        this.bufferROIXMin = bufferROIXMin;
    }

    public void setBufferROIXMax(int bufferROIXMax) {
        this.bufferROIXMax = bufferROIXMax;
    }

    public void setBufferROIYMin(int bufferROIYMin) {
        this.bufferROIYMin = bufferROIYMin;
    }

    public void setBufferROIYMax(int bufferROIYMax) {
        this.bufferROIYMax = bufferROIYMax;
    }

    public void setTheY(int theY) {
        this.theY = theY;
    }

    public void setInDatas(float[][] inDatas) {
        this.inDatas = inDatas;
    }

    protected float[] inDatas() {
        return this.inDatas[0];
    }

    protected float[] inDatas(int index) {
        return this.inDatas[index - 1];
    }

    public void setOutDatas(double[][] outDatas) {
        this.outDatas = outDatas;
    }

    public double[][] outDatas() {
        return this.outDatas;
    }

    protected int theY() {
        return this.theY;
    }

    protected int width() {
        return this.width;
    }

    protected int height() {
        return this.height;
    }

    public int bufferROIXMin() {
        return this.bufferROIXMin;
    }

    public int bufferROIXMax() {
        return this.bufferROIXMax;
    }

    public int bufferROIYMin() {
        return this.bufferROIYMin;
    }

    public int bufferROIYMax() {
        return this.bufferROIYMax;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.coeff = null;
        this.inDatas = null;
        this.outDatas = null;
        this.unfilters = null;
    }
}

