/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.selected.grainbocager;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedLandscapeMetricKernel;
import java.util.Set;

public class GrainBocagerSelectedDistanceBocageKernel
extends SelectedLandscapeMetricKernel {
    private float minHauteur;
    private float seuilMax;

    public GrainBocagerSelectedDistanceBocageKernel(int windowSize, Set<Pixel> pixels, float[] coeff, EnteteRaster entete, String windowsPath, float minHauteur, float seuilMax) {
        super(windowSize, pixels, coeff, entete, windowsPath);
        this.minHauteur = minHauteur;
        this.seuilMax = seuilMax;
    }

    @Override
    protected void processPixel(Pixel p, int x, int y) {
        this.outDatas().get((Object)p)[0] = 1.0;
        this.outDatas().get((Object)p)[1] = this.inDatas()[y * this.width() + x];
        int mid = this.windowSize() / 2;
        float nb_nodata = 0.0f;
        float nb = 0.0f;
        float min = 1.0f;
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                double R;
                double r;
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                float coeff = this.coeff()[ic];
                if (!(coeff > 0.0f)) continue;
                float v = this.inDatas()[(y + dy) * this.width() + (x + dx)];
                nb += coeff;
                if (v == (float)this.noDataValue()) {
                    nb_nodata += coeff;
                    continue;
                }
                if (!(v >= this.minHauteur)) continue;
                if (v > this.seuilMax) {
                    v = this.seuilMax;
                }
                if (!((r = this.cellSize() * Math.sqrt(dx * dx + dy * dy)) < (R = (double)(v * this.inDatas(2)[(y + dy) * this.width() + (x + dx)])))) continue;
                min = (float)Math.min((double)min, r / R);
            }
        }
        this.outDatas().get((Object)p)[2] = nb;
        this.outDatas().get((Object)p)[3] = nb_nodata;
        this.outDatas().get((Object)p)[6] = min;
    }
}

