/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.selected.grainbocager;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedLandscapeMetricKernel;
import java.util.Set;

public class GrainBocagerSelectedDetectionBocageKernel
extends SelectedLandscapeMetricKernel {
    private float minHauteur;

    public GrainBocagerSelectedDetectionBocageKernel(int windowSize, Set<Pixel> pixels, float[] coeff, EnteteRaster entete, String windowsPath, float minHauteur) {
        super(windowSize, pixels, coeff, entete, windowsPath);
        this.minHauteur = minHauteur;
    }

    @Override
    protected void processPixel(Pixel p, int x, int y) {
        this.outDatas().get((Object)p)[0] = 1.0;
        this.outDatas().get((Object)p)[1] = this.inDatas()[y * this.width() + x];
        int mid = this.windowSize() / 2;
        float vCentral = this.inDatas()[y * this.width() + x];
        if (vCentral == (float)this.noDataValue()) {
            this.outDatas().get((Object)p)[2] = 0.0;
            this.outDatas().get((Object)p)[3] = 1.0;
            this.outDatas().get((Object)p)[4] = this.noDataValue();
        } else if (vCentral < this.minHauteur) {
            this.outDatas().get((Object)p)[2] = 1.0;
            this.outDatas().get((Object)p)[3] = 0.0;
            this.outDatas().get((Object)p)[4] = 0.0;
        } else {
            float nb_nodata = 0.0f;
            float nb_value = 0.0f;
            float sum = 0.0f;
            for (int dy = -mid; dy <= mid; ++dy) {
                if (y + dy < 0 || y + dy >= this.height()) continue;
                for (int dx = -mid; dx <= mid; ++dx) {
                    if (x + dx < 0 || x + dx >= this.width()) continue;
                    int ic = (dy + mid) * this.windowSize() + (dx + mid);
                    float coeff = this.coeff()[ic];
                    if (!(coeff > 0.0f)) continue;
                    float v = this.inDatas()[(y + dy) * this.width() + (x + dx)];
                    nb_value += coeff;
                    if (v == (float)this.noDataValue()) {
                        nb_nodata += coeff;
                        continue;
                    }
                    if (!(v >= this.minHauteur)) continue;
                    sum += coeff;
                }
            }
            this.outDatas().get((Object)p)[2] = nb_value;
            this.outDatas().get((Object)p)[3] = nb_nodata;
            this.outDatas().get((Object)p)[4] = sum;
        }
    }
}

