/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.selected.functional;

import fr.inrae.act.bagap.apiland.analysis.distance.DistanceFunction;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.chloe.distance.analysis.functional.TabRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedLandscapeMetricKernel;
import java.util.Arrays;
import java.util.Set;

public abstract class SelectedFunctionalKernel
extends SelectedLandscapeMetricKernel {
    private double cellSize;
    private double radius;
    private DistanceFunction function;

    protected SelectedFunctionalKernel(int windowSize, Set<Pixel> pixels, float[] coeff, EnteteRaster entete, DistanceFunction function, double radius, String windowsPath) {
        super(windowSize, pixels, coeff, entete, windowsPath);
        this.cellSize = entete.cellsize();
        this.radius = radius;
        this.function = function;
    }

    protected double radius() {
        return this.radius;
    }

    protected float[] generateImage(int x, int y, int mid) {
        float[] image = new float[this.windowSize() * this.windowSize()];
        Arrays.fill(image, (float)Raster.getNoDataValue());
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                image[ic] = this.inDatas()[(y + dy) * this.width() + (x + dx)];
            }
        }
        return image;
    }

    protected float[] generateResistance(int x, int y, int mid) {
        float[] resistance = new float[this.windowSize() * this.windowSize()];
        Arrays.fill(resistance, (float)Raster.getNoDataValue());
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                resistance[ic] = this.inDatas(2)[(y + dy) * this.width() + (x + dx)];
            }
        }
        return resistance;
    }

    protected float[] calculateDistance(float[] resistance) {
        float[] distance = new float[this.windowSize() * this.windowSize()];
        TabRCMDistanceAnalysis rcm = new TabRCMDistanceAnalysis(distance, resistance, this.windowSize(), this.windowSize(), (float)this.cellSize, this.noDataValue(), this.radius);
        rcm.allRun();
        return distance;
    }

    protected void generateCoeff(float[] distance) {
        float[] coeff = new float[this.windowSize() * this.windowSize()];
        for (int ind = 0; ind < distance.length; ++ind) {
            float dist = distance[ind];
            if (dist >= 0.0f && (double)dist <= this.radius) {
                if (this.function == null) {
                    coeff[ind] = 1.0f;
                    continue;
                }
                coeff[ind] = (float)this.function.interprete(distance[ind]);
                continue;
            }
            coeff[ind] = 0.0f;
        }
        this.setCoeff(coeff);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.function = null;
    }
}

