/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.selected;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedLandscapeMetricKernel;
import java.util.Set;

public class SelectedQuantitativeKernel
extends SelectedLandscapeMetricKernel {
    private final float threshold;

    public SelectedQuantitativeKernel(int windowSize, Set<Pixel> pixels, float[] coeff, EnteteRaster entete, String windowsPath) {
        this(windowSize, pixels, coeff, entete, windowsPath, -1.0f);
    }

    public SelectedQuantitativeKernel(int windowSize, Set<Pixel> pixels, float[] coeff, EnteteRaster entete, String windowsPath, float threshold) {
        super(windowSize, pixels, coeff, entete, windowsPath);
        this.threshold = threshold;
    }

    @Override
    protected void processPixel(Pixel p, int x, int y) {
        this.outDatas().get((Object)p)[0] = 1.0;
        this.outDatas().get((Object)p)[1] = this.inDatas()[y * this.width() + x];
        int mid = this.windowSize() / 2;
        float nb_nodata = 0.0f;
        float nb = 0.0f;
        float sum = 0.0f;
        float square_sum = 0.0f;
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        if (this.threshold != -1.0f) {
            for (int dy = -mid; dy <= mid; ++dy) {
                if (y + dy < 0 || y + dy >= this.height()) continue;
                for (int dx = -mid; dx <= mid; ++dx) {
                    if (x + dx < 0 || x + dx >= this.width()) continue;
                    int ic = (dy + mid) * this.windowSize() + (dx + mid);
                    float coeff = this.coeff()[ic];
                    if (!(coeff > 0.0f)) continue;
                    float v = this.inDatas()[(y + dy) * this.width() + (x + dx)];
                    nb += coeff;
                    if (v == (float)this.noDataValue()) {
                        nb_nodata += coeff;
                        continue;
                    }
                    if (v > this.threshold) {
                        sum += this.threshold * coeff;
                        square_sum += this.threshold * coeff * this.threshold * coeff;
                        min = Math.min(min, this.threshold * coeff);
                        max = Math.max(max, this.threshold * coeff);
                        continue;
                    }
                    sum += v * coeff;
                    square_sum += v * coeff * v * coeff;
                    min = Math.min(min, v * coeff);
                    max = Math.max(max, v * coeff);
                }
            }
        } else {
            for (int dy = -mid; dy <= mid; ++dy) {
                if (y + dy < 0 || y + dy >= this.height()) continue;
                for (int dx = -mid; dx <= mid; ++dx) {
                    if (x + dx < 0 || x + dx >= this.width()) continue;
                    int ic = (dy + mid) * this.windowSize() + (dx + mid);
                    float coeff = this.coeff()[ic];
                    if (!(coeff > 0.0f)) continue;
                    float v = this.inDatas()[(y + dy) * this.width() + (x + dx)];
                    nb += coeff;
                    if (v == (float)this.noDataValue()) {
                        nb_nodata += coeff;
                        continue;
                    }
                    sum += v * coeff;
                    square_sum += v * coeff * v * coeff;
                    min = Math.min(min, v * coeff);
                    max = Math.max(max, v * coeff);
                }
            }
        }
        this.outDatas().get((Object)p)[2] = nb;
        this.outDatas().get((Object)p)[3] = nb_nodata;
        this.outDatas().get((Object)p)[4] = sum;
        this.outDatas().get((Object)p)[5] = square_sum;
        this.outDatas().get((Object)p)[6] = min;
        this.outDatas().get((Object)p)[7] = max;
    }
}

