/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.selected;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.cluster.TabClusteringOutput;
import fr.inrae.act.bagap.chloe.cluster.chess.TabQueenDiscreteClusteringAnalysis;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedLandscapeMetricKernel;
import java.util.Set;

public class SelectedPatchKernel
extends SelectedLandscapeMetricKernel {
    private int[] values;

    public SelectedPatchKernel(int windowSize, Set<Pixel> pixels, float[] coeff, EnteteRaster entete, int[] values, String windowsPath) {
        super(windowSize, pixels, coeff, entete, windowsPath);
        this.values = values;
    }

    @Override
    protected void processPixel(Pixel p, int x, int y) {
        int i;
        this.outDatas().get((Object)p)[0] = 1.0;
        this.outDatas().get((Object)p)[1] = this.inDatas()[y * this.width() + x];
        for (int i2 = 2; i2 < this.outDatas().get(p).length; ++i2) {
            this.outDatas().get((Object)p)[i2] = 0.0;
        }
        int mid = this.windowSize() / 2;
        float[] tabCover = new float[this.windowSize() * this.windowSize()];
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                float coeff = this.coeff()[ic];
                if (!(coeff > 0.0f)) continue;
                int v = (int)this.inDatas()[(y + dy) * this.width() + (x + dx)];
                double[] dArray = this.outDatas().get(p);
                dArray[2] = dArray[2] + (double)coeff;
                if (v == this.noDataValue()) {
                    double[] dArray2 = this.outDatas().get(p);
                    dArray2[3] = dArray2[3] + (double)coeff;
                }
                tabCover[(dy + mid) * this.windowSize() + (dx + mid)] = v;
            }
        }
        TabQueenDiscreteClusteringAnalysis ca = new TabQueenDiscreteClusteringAnalysis(tabCover, this.windowSize(), this.windowSize(), this.values, this.noDataValue());
        float[] tabCluster = (float[])ca.allRun();
        TabClusteringOutput cto = new TabClusteringOutput(tabCluster, tabCover, this.values, this.cellSize(), this.noDataValue());
        cto.allRun();
        this.outDatas().get((Object)p)[4] = cto.getNbPatch();
        this.outDatas().get((Object)p)[5] = (float)cto.getTotalSurface();
        this.outDatas().get((Object)p)[6] = (float)cto.getMaxSurface();
        this.outDatas().get((Object)p)[7] = (float)cto.getTotalSurfaceCarre();
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas().get((Object)p)[i + 8] = cto.getNbPatch(this.values[i]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas().get((Object)p)[i + 8 + this.values.length] = (float)cto.getTotalSurface(this.values[i]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas().get((Object)p)[i + 8 + 2 * this.values.length] = (float)cto.getMaxSurface(this.values[i]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas().get((Object)p)[i + 8 + 3 * this.values.length] = (float)cto.getTotalSurfaceCarre(this.values[i]);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.values = null;
    }
}

