/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.selected;

import com.aparapi.Kernel;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.raster.PixelWithID;
import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.apiland.util.CoordinateManager;
import fr.inrae.act.bagap.chloe.window.kernel.LandscapeMetricKernel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class SelectedLandscapeMetricKernel
extends Kernel
implements LandscapeMetricKernel {
    private final int windowSize;
    private float[] coeff;
    private final EnteteRaster entete;
    private float[][] inDatas;
    private Map<Pixel, double[]> outDatas;
    private int localROIY;
    private int width;
    private int height;
    private int bufferROIXMin;
    private int bufferROIXMax;
    private int bufferROIYMin;
    private int bufferROIYMax;
    private Map<Integer, Map<Integer, Set<Pixel>>> mapPixels;
    private String windowsPath;
    private static int index = 0;

    protected SelectedLandscapeMetricKernel(int windowSize, Set<Pixel> pixels, float[] coeff, EnteteRaster entete, String windowsPath) {
        this.setExplicit(true);
        this.setExecutionModeWithoutFallback(Kernel.EXECUTION_MODE.JTP);
        this.windowSize = windowSize;
        this.coeff = coeff;
        this.entete = entete;
        this.windowsPath = windowsPath;
        this.mapPixels = new TreeMap<Integer, Map<Integer, Set<Pixel>>>();
        for (Pixel p : pixels) {
            if (!this.mapPixels.containsKey(p.x())) {
                this.mapPixels.put(p.x(), new TreeMap());
            }
            if (!this.mapPixels.get(p.x()).containsKey(p.y())) {
                this.mapPixels.get(p.x()).put(p.y(), new HashSet());
            }
            this.mapPixels.get(p.x()).get(p.y()).add(p);
        }
    }

    public void applySelectedWindow(int buffer, int localROIY) {
        this.localROIY = localROIY;
        this.execute((this.width - this.bufferROIXMin - this.bufferROIXMax) * buffer);
    }

    public void run() {
        int x = this.bufferROIXMin() + this.getGlobalId(0) % (this.width() - this.bufferROIXMin() - this.bufferROIXMax());
        int y = this.bufferROIYMin() + this.getGlobalId(0) / (this.width() - this.bufferROIXMin() - this.bufferROIXMax());
        int px = this.getGlobalId(0) % this.width();
        int py = this.localROIY + this.getGlobalId(0) / this.width();
        if (this.mapPixels.containsKey(px) && this.mapPixels.get(px).containsKey(py)) {
            for (Pixel lp : this.mapPixels.get(px).get(py)) {
                this.processPixel(lp, x, y);
                this.exportFilters(lp, x, y);
            }
        }
    }

    protected void processPixel(Pixel p, int x, int y) {
    }

    public int windowSize() {
        return this.windowSize;
    }

    protected void setCoeff(float[] coeff) {
        this.coeff = coeff;
    }

    protected float[] coeff() {
        return this.coeff;
    }

    protected int noDataValue() {
        return this.entete.noDataValue();
    }

    protected double cellSize() {
        return this.entete.cellsize();
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setBufferROIXMin(int bufferROIXMin) {
        this.bufferROIXMin = bufferROIXMin;
    }

    public void setBufferROIXMax(int bufferROIXMax) {
        this.bufferROIXMax = bufferROIXMax;
    }

    public void setBufferROIYMin(int bufferROIYMin) {
        this.bufferROIYMin = bufferROIYMin;
    }

    public void setBufferROIYMax(int bufferROIYMax) {
        this.bufferROIYMax = bufferROIYMax;
    }

    public void setInDatas(float[][] inDatas) {
        this.inDatas = inDatas;
    }

    protected float[] inDatas() {
        return this.inDatas[0];
    }

    protected float[] inDatas(int index) {
        return this.inDatas[index - 1];
    }

    public void setOutDatas(Map<Pixel, double[]> outDatas) {
        this.outDatas = outDatas;
    }

    public Map<Pixel, double[]> outDatas() {
        return this.outDatas;
    }

    protected int width() {
        return this.width;
    }

    protected int height() {
        return this.height;
    }

    public int bufferROIXMin() {
        return this.bufferROIXMin;
    }

    public int bufferROIXMax() {
        return this.bufferROIXMax;
    }

    public int bufferROIYMin() {
        return this.bufferROIYMin;
    }

    public int bufferROIYMax() {
        return this.bufferROIYMax;
    }

    public String windowsPath() {
        return this.windowsPath;
    }

    private void exportFilters(Pixel p, int x, int y) {
        if (this.windowsPath != null) {
            int mid = this.windowSize() / 2;
            float[] image = new float[this.windowSize() * this.windowSize()];
            Arrays.fill(image, (float)Raster.getNoDataValue());
            for (int dy = -mid; dy <= mid; ++dy) {
                if (y + dy < 0 || y + dy >= this.height()) continue;
                for (int dx = -mid; dx <= mid; ++dx) {
                    if (x + dx < 0 || x + dx >= this.width()) continue;
                    int ic = (dy + mid) * this.windowSize() + (dx + mid);
                    float coeff = this.coeff()[ic];
                    if (!(coeff > 0.0f)) continue;
                    image[ic] = this.inDatas()[(y + dy) * this.width() + (x + dx)];
                }
            }
            double minx = CoordinateManager.getProjectedX(this.entete, p.x() - mid) - (double)(this.entete.cellsize() / 2.0f);
            double maxx = CoordinateManager.getProjectedX(this.entete, p.x() + mid) + (double)(this.entete.cellsize() / 2.0f);
            double miny = CoordinateManager.getProjectedY(this.entete, p.y() - mid) + (double)(this.entete.cellsize() / 2.0f);
            double maxy = CoordinateManager.getProjectedY(this.entete, p.y() + mid) - (double)(this.entete.cellsize() / 2.0f);
            EnteteRaster localEntete = new EnteteRaster(this.windowSize(), this.windowSize(), minx, maxx, miny, maxy, this.entete.cellsize(), this.entete.noDataValue());
            if (p instanceof PixelWithID) {
                double X = ((PixelWithID)p).getX();
                double Y = ((PixelWithID)p).getY();
                CoverageManager.write(this.windowsPath + "window_" + ((PixelWithID)p).getId() + ".tif", image, localEntete);
            } else {
                double X = CoordinateManager.getProjectedX(this.entete, p.x());
                double Y = CoordinateManager.getProjectedY(this.entete, p.y());
                CoverageManager.write(this.windowsPath + "window_" + X + "-" + Y + ".tif", image, localEntete);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.coeff = null;
        this.inDatas = null;
        this.outDatas = null;
        this.mapPixels.clear();
        this.mapPixels = null;
    }
}

