/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.selected;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedLandscapeMetricKernel;
import java.util.Set;

public class SelectedCountValueKernel
extends SelectedLandscapeMetricKernel {
    private int[] mapValues;

    public SelectedCountValueKernel(int windowSize, Set<Pixel> pixels, float[] coeff, EnteteRaster entete, int[] values, String windowsPath) {
        super(windowSize, pixels, coeff, entete, windowsPath);
        int maxV = 0;
        for (int v : values) {
            maxV = Math.max(v, maxV);
        }
        this.mapValues = new int[++maxV];
        for (int i = 0; i < values.length; ++i) {
            this.mapValues[values[i]] = i;
        }
    }

    @Override
    protected void processPixel(Pixel p, int x, int y) {
        this.outDatas().get((Object)p)[0] = 1.0;
        this.outDatas().get((Object)p)[1] = this.inDatas()[y * this.width() + x];
        int mid = this.windowSize() / 2;
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                float coeff = this.coeff()[ic];
                if (!(coeff > 0.0f)) continue;
                int v = (int)this.inDatas()[(y + dy) * this.width() + (x + dx)];
                double[] dArray = this.outDatas().get(p);
                dArray[2] = dArray[2] + (double)coeff;
                if (v == this.noDataValue()) {
                    double[] dArray2 = this.outDatas().get(p);
                    dArray2[3] = dArray2[3] + (double)coeff;
                    continue;
                }
                if (v == 0) {
                    double[] dArray3 = this.outDatas().get(p);
                    dArray3[4] = dArray3[4] + (double)coeff;
                    continue;
                }
                int mv = this.mapValues[v];
                double[] dArray4 = this.outDatas().get(p);
                int n = mv + 5;
                dArray4[n] = dArray4[n] + (double)coeff;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mapValues = null;
    }
}

