/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.selected;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedLandscapeMetricKernel;
import java.util.Set;

public class SelectedCountValueAndCoupleKernel
extends SelectedLandscapeMetricKernel {
    private final int nbValues;
    private int[][] mapCouples;
    private int[] mapValues;

    public SelectedCountValueAndCoupleKernel(int windowSize, Set<Pixel> pixels, float[] coeff, EnteteRaster entete, int[] values, String windowsPath) {
        super(windowSize, pixels, coeff, entete, windowsPath);
        this.nbValues = values.length;
        int maxV = 0;
        for (int v : values) {
            maxV = Math.max(v, maxV);
        }
        this.mapValues = new int[++maxV];
        for (int i = 0; i < values.length; ++i) {
            this.mapValues[values[i]] = i;
        }
        this.mapCouples = new int[values.length][values.length];
        int index = 0;
        for (int v : values) {
            this.mapCouples[this.mapValues[v]][this.mapValues[v]] = index++;
        }
        for (int v1 : values) {
            for (int v2 : values) {
                if (v1 >= v2) continue;
                this.mapCouples[this.mapValues[v1]][this.mapValues[v2]] = index;
                this.mapCouples[this.mapValues[v2]][this.mapValues[v1]] = index++;
            }
        }
    }

    @Override
    protected void processPixel(Pixel p, int x, int y) {
        this.outDatas().get((Object)p)[0] = 1.0;
        this.outDatas().get((Object)p)[1] = this.inDatas()[y * this.width() + x];
        int mid = this.windowSize() / 2;
        for (int dy = -mid; dy <= mid; ++dy) {
            if (y + dy < 0 || y + dy >= this.height()) continue;
            for (int dx = -mid; dx <= mid; ++dx) {
                int mv;
                if (x + dx < 0 || x + dx >= this.width()) continue;
                int ic = (dy + mid) * this.windowSize() + (dx + mid);
                float coeff = this.coeff()[ic];
                if (!(coeff > 0.0f)) continue;
                short v = (short)this.inDatas()[(y + dy) * this.width() + (x + dx)];
                double[] dArray = this.outDatas().get(p);
                dArray[2] = dArray[2] + (double)coeff;
                if (v == this.noDataValue()) {
                    double[] dArray2 = this.outDatas().get(p);
                    dArray2[3] = dArray2[3] + (double)coeff;
                } else if (v == 0) {
                    double[] dArray3 = this.outDatas().get(p);
                    dArray3[4] = dArray3[4] + (double)coeff;
                } else {
                    mv = this.mapValues[v];
                    double[] dArray4 = this.outDatas().get(p);
                    int n = mv + 5;
                    dArray4[n] = dArray4[n] + (double)coeff;
                }
                if (dy > -mid && y + dy > 0) {
                    int ic_V = (dy + mid - 1) * this.windowSize() + (dx + mid);
                    if (this.coeff()[ic_V] > 0.0f) {
                        short v_V = (short)this.inDatas()[(y + dy - 1) * this.width() + (x + dx)];
                        double[] dArray5 = this.outDatas().get(p);
                        int n = this.nbValues + 5;
                        dArray5[n] = dArray5[n] + (double)coeff;
                        if (v == this.noDataValue() || v_V == this.noDataValue()) {
                            double[] dArray6 = this.outDatas().get(p);
                            int n2 = this.nbValues + 6;
                            dArray6[n2] = dArray6[n2] + (double)coeff;
                        } else if (v == 0 || v_V == 0) {
                            double[] dArray7 = this.outDatas().get(p);
                            int n3 = this.nbValues + 7;
                            dArray7[n3] = dArray7[n3] + (double)coeff;
                        } else {
                            mv = this.mapCouples[this.mapValues[v]][this.mapValues[v_V]];
                            double[] dArray8 = this.outDatas().get(p);
                            int n4 = this.nbValues + mv + 8;
                            dArray8[n4] = dArray8[n4] + (double)coeff;
                        }
                    }
                }
                if (dx <= -mid || x + dx <= 0) continue;
                int ic_H = (dy + mid) * this.windowSize() + (dx + mid - 1);
                if (!(this.coeff()[ic_H] > 0.0f)) continue;
                short v_H = (short)this.inDatas()[(y + dy) * this.width() + (x + dx - 1)];
                double[] dArray9 = this.outDatas().get(p);
                int n = this.nbValues + 5;
                dArray9[n] = dArray9[n] + (double)coeff;
                if (v == this.noDataValue() || v_H == this.noDataValue()) {
                    double[] dArray10 = this.outDatas().get(p);
                    int n5 = this.nbValues + 6;
                    dArray10[n5] = dArray10[n5] + (double)coeff;
                    continue;
                }
                if (v == 0 || v_H == 0) {
                    double[] dArray11 = this.outDatas().get(p);
                    int n6 = this.nbValues + 7;
                    dArray11[n6] = dArray11[n6] + (double)coeff;
                    continue;
                }
                mv = this.mapCouples[this.mapValues[v]][this.mapValues[v_H]];
                double[] dArray12 = this.outDatas().get(p);
                int n7 = this.nbValues + mv + 8;
                dArray12[n7] = dArray12[n7] + (double)coeff;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mapCouples = null;
        this.mapValues = null;
    }
}

