/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.map;

import fr.inrae.act.bagap.chloe.cluster.TabClusteringOutput;
import fr.inrae.act.bagap.chloe.cluster.chess.TabQueenDiscreteClusteringAnalysis;
import fr.inrae.act.bagap.chloe.window.kernel.map.MapLandscapeMetricKernel;

public class MapPatchKernel
extends MapLandscapeMetricKernel {
    private int[] values;
    private double cellSize;

    public MapPatchKernel(int noDataValue, int[] values, double cellSize) {
        super(noDataValue);
        this.values = values;
        this.cellSize = cellSize;
    }

    @Override
    public void applyMapWindow(int theY) {
        int i;
        TabQueenDiscreteClusteringAnalysis ca = new TabQueenDiscreteClusteringAnalysis(this.inDatas(), this.width(), this.height(), this.values, this.noDataValue());
        float[] tabCluster = (float[])ca.allRun();
        TabClusteringOutput cto = new TabClusteringOutput(tabCluster, this.inDatas(), this.values, this.cellSize, this.noDataValue());
        cto.allRun();
        this.outDatas()[2] = this.inDatas().length;
        this.outDatas()[3] = ca.getNbNoDataValue();
        this.outDatas()[4] = cto.getNbPatch();
        this.outDatas()[5] = (float)cto.getTotalSurface();
        this.outDatas()[6] = (float)cto.getMaxSurface();
        this.outDatas()[7] = (float)cto.getTotalSurfaceCarre();
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas()[i + 8] = cto.getNbPatch(this.values[i]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas()[i + 8 + this.values.length] = (float)cto.getTotalSurface(this.values[i]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas()[i + 8 + 2 * this.values.length] = (float)cto.getMaxSurface(this.values[i]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas()[i + 8 + 3 * this.values.length] = (float)cto.getTotalSurfaceCarre(this.values[i]);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.values = null;
    }
}

