/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.grid;

import fr.inrae.act.bagap.chloe.cluster.TabClusteringOutput;
import fr.inrae.act.bagap.chloe.cluster.chess.TabQueenDiscreteClusteringAnalysis;
import fr.inrae.act.bagap.chloe.window.kernel.grid.GridLandscapeMetricKernel;

public class GridPatchKernel
extends GridLandscapeMetricKernel {
    private int[] values;
    private double cellSize;

    public GridPatchKernel(int gridSize, int noDataValue, int[] values, double cellSize) {
        super(gridSize, noDataValue);
        this.values = values;
        this.cellSize = cellSize;
    }

    @Override
    protected void processGrid(int x, int theY) {
        int i;
        this.outDatas()[x][0] = 1.0;
        for (int i2 = 1; i2 < this.outDatas()[0].length; ++i2) {
            this.outDatas()[x][i2] = 0.0;
        }
        float[] tabCover = new float[this.gridSize() * this.gridSize()];
        for (int y = 0; y < this.gridSize(); ++y) {
            if (theY + y >= this.height()) continue;
            for (int lx = 0; lx < this.gridSize(); ++lx) {
                if (x * this.gridSize() + lx >= this.width()) continue;
                int v = (int)this.inDatas()[(theY + y) * this.width() + (x * this.gridSize() + lx)];
                double[] dArray = this.outDatas()[x];
                dArray[2] = dArray[2] + 1.0;
                if (v == this.noDataValue()) {
                    double[] dArray2 = this.outDatas()[x];
                    dArray2[3] = dArray2[3] + 1.0;
                }
                tabCover[y * this.gridSize() + lx] = v;
            }
        }
        TabQueenDiscreteClusteringAnalysis ca = new TabQueenDiscreteClusteringAnalysis(tabCover, this.gridSize(), this.gridSize(), this.values, this.noDataValue());
        float[] tabCluster = (float[])ca.allRun();
        TabClusteringOutput cto = new TabClusteringOutput(tabCluster, tabCover, this.values, this.cellSize, this.noDataValue());
        cto.allRun();
        this.outDatas()[x][4] = cto.getNbPatch();
        this.outDatas()[x][5] = (float)cto.getTotalSurface();
        this.outDatas()[x][6] = (float)cto.getMaxSurface();
        this.outDatas()[x][7] = (float)cto.getTotalSurfaceCarre();
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas()[x][i + 8] = cto.getNbPatch(this.values[i]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas()[x][i + 8 + this.values.length] = (float)cto.getTotalSurface(this.values[i]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas()[x][i + 8 + 2 * this.values.length] = (float)cto.getMaxSurface(this.values[i]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.outDatas()[x][i + 8 + 3 * this.values.length] = (float)cto.getTotalSurfaceCarre(this.values[i]);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.values = null;
    }
}

