/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.grid;

import fr.inrae.act.bagap.chloe.window.kernel.grid.GridLandscapeMetricKernel;

public class GridCountValueKernel
extends GridLandscapeMetricKernel {
    private int[] mapValues;

    public GridCountValueKernel(int gridSize, int noDataValue, int[] values) {
        super(gridSize, noDataValue);
        int maxV = 0;
        for (int v : values) {
            maxV = Math.max(v, maxV);
        }
        this.mapValues = new int[++maxV];
        for (int i = 0; i < values.length; ++i) {
            this.mapValues[values[i]] = i;
        }
    }

    @Override
    protected void processGrid(int x, int theY) {
        this.outDatas()[x][0] = 1.0;
        for (int i = 1; i < this.outDatas()[0].length; ++i) {
            this.outDatas()[x][i] = 0.0;
        }
        for (int y = 0; y < this.gridSize(); ++y) {
            if (theY + y >= this.height()) continue;
            for (int lx = 0; lx < this.gridSize(); ++lx) {
                if (x * this.gridSize() + lx >= this.width()) continue;
                short v = (short)this.inDatas()[(theY + y) * this.width() + (x * this.gridSize() + lx)];
                double[] dArray = this.outDatas()[x];
                dArray[2] = dArray[2] + 1.0;
                if (v == this.noDataValue()) {
                    double[] dArray2 = this.outDatas()[x];
                    dArray2[3] = dArray2[3] + 1.0;
                    continue;
                }
                if (v == 0) {
                    double[] dArray3 = this.outDatas()[x];
                    dArray3[4] = dArray3[4] + 1.0;
                    continue;
                }
                int mv = this.mapValues[v];
                double[] dArray4 = this.outDatas()[x];
                int n = mv + 5;
                dArray4[n] = dArray4[n] + 1.0;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mapValues = null;
    }
}

